/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;

public class EditGeomPointIterator
implements Iterator<Point> {
    private final Iterator<PrimitiveShape> currentShape;
    private Iterator<Point> current;
    private Point next;
    private final Collection<Point> selectedPoints;

    public EditGeomPointIterator(EditGeom geom, Collection<Point> selectedPoints) {
        this.currentShape = geom.iterator();
        this.current = this.currentShape.next().iterator();
        this.selectedPoints = selectedPoints;
    }

    public EditGeomPointIterator(EditGeom geom) {
        this(geom, Collections.emptySet());
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        do {
            this.next = this.getNext();
        } while (this.next != null && this.selectedPoints.contains(this.next));
        return this.next != null;
    }

    private Point getNext() {
        if (this.current.hasNext()) {
            return this.current.next();
        }
        if (this.currentShape.hasNext()) {
            this.current = this.currentShape.next().iterator();
            return this.getNext();
        }
        return null;
    }

    @Override
    public Point next() {
        Point result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

