/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.tools.edit.support.AbstractPathIterator;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditBlackboardAdapter;
import net.refractions.udig.tools.edit.support.EditBlackboardEvent;
import net.refractions.udig.tools.edit.support.EditBlackboardListener;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;

public class EditGeomPathIterator
extends AbstractPathIterator {
    protected boolean isPolygon;
    private static final Map<EditBlackboard, EditBlackboardListener> listeners = new HashMap<EditBlackboard, EditBlackboardListener>();
    private static final Map<EditGeom, EditGeomPathIterator> map = new HashMap<EditGeom, EditGeomPathIterator>();

    protected EditGeomPathIterator(EditGeom shape) {
        super(shape);
    }

    public void dispose() {
    }

    public static EditGeomPathIterator getPathIterator(EditGeom geom) {
        EditGeomPathIterator iter = map.get(geom);
        if (iter == null) {
            iter = new EditGeomPathIterator(geom);
            EditBlackboardListener listener = listeners.get(geom.getEditBlackboard());
            if (listener == null) {
                listener = new EditBlackboardAdapter(){

                    @Override
                    public void changed(EditBlackboardEvent event) {
                        if (event.getType() == EditBlackboardEvent.EventType.REMOVE_GEOMS) {
                            List geoms = (List)event.getOldValue();
                            for (EditGeom geom : geoms) {
                                map.remove(geom);
                            }
                        }
                    }

                    @Override
                    public void batchChange(List<EditBlackboardEvent> e) {
                        for (EditBlackboardEvent event : e) {
                            this.changed(event);
                        }
                    }
                };
                listeners.put(geom.getEditBlackboard(), listener);
            }
            geom.getEditBlackboard().getListeners().add(listener);
            map.put(geom, iter);
        }
        return iter;
    }

    @Override
    public int currentSegment(float[] coords) {
        int result = super.currentSegment(coords);
        if ((this.isPolygon || this.geom.getShapeType() == ShapeType.POLYGON) && result != 0 && !this.points.hasNext() && this.isClosed(this.currentShape)) {
            result = 4;
        }
        return result;
    }

    protected boolean isClosed(PrimitiveShape shape) {
        return shape.getPoint(0).equals(shape.getPoint(shape.getNumPoints() - 1));
    }

    public void setPolygon(boolean isPolygon) {
        this.isPolygon = isPolygon;
    }

    public boolean isPolygon() {
        return this.isPolygon;
    }
}

