/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.Selection;

public class EditBlackboardEvent {
    private final Object source;
    private final Object before;
    private final Object after;
    private final EventType type;
    private EditBlackboard editBlackboard;
    public Object privateData;

    public EditBlackboardEvent(EditBlackboard bb, Object source2, EventType type2, Object before2, Object after2) {
        this.assertLegalValues(source2, type2, before2, after2);
        this.editBlackboard = bb;
        this.source = source2;
        this.type = type2;
        this.before = before2;
        this.after = after2;
    }

    public Object getSource() {
        return this.source;
    }

    public Object getNewValue() {
        return this.after;
    }

    public Object getOldValue() {
        return this.before;
    }

    public EventType getType() {
        return this.type;
    }

    private void assertLegalValues(Object source2, EventType type2, Object before2, Object after2) {
        switch (type2) {
            case ADD_GEOMS: {
                if (!(source2 instanceof EditBlackboard)) {
                    throw new IllegalArgumentException("The source of a " + (Object)((Object)type2) + " event must be a " + "EditBlackboard was " + source2.getClass().getName());
                }
                if (before2 != null) {
                    throw new IllegalArgumentException("The before value of a " + (Object)((Object)type2) + " event be null was " + before2.getClass().getName());
                }
                if (!(after2 instanceof Collection)) {
                    throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be " + "be a Collection was " + after2.getClass().getName());
                }
                if (((Collection)after2).size() < 1) {
                    throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be " + "be larger than 0");
                }
                for (Object obj : (Collection)after2) {
                    if (obj instanceof EditGeom) continue;
                    throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be " + "be a Collection of EditGeoms was " + obj.getClass().getName());
                }
                break;
            }
            case ADD_POINT: {
                if (!(source2 instanceof PrimitiveShape)) {
                    throw new IllegalArgumentException("The source of a " + (Object)((Object)type2) + " event must be a " + "PrimitiveShape was " + source2.getClass().getName());
                }
                if (before2 != null) {
                    throw new IllegalArgumentException("The before value of a " + (Object)((Object)type2) + " event be null was " + this.before.getClass().getName());
                }
                if (after2 instanceof Point) break;
                throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be " + "be a Point was " + after2.getClass().getName());
            }
            case MOVE_POINT: {
                if (!(source2 instanceof Set)) {
                    throw new IllegalArgumentException("The source of a " + (Object)((Object)type2) + " event must be " + "be a Set of PrimitiveShapes was " + source2.getClass().getName());
                }
                if (((Set)source2).size() < 1) {
                    throw new IllegalArgumentException("The source value of a " + (Object)((Object)type2) + " event must be " + "be larger than 0");
                }
                for (Object obj : (Set)source2) {
                    if (obj instanceof PrimitiveShape) continue;
                    throw new IllegalArgumentException("The source of a " + (Object)((Object)type2) + " event must be " + "be a Set of PrimitiveShape was " + obj.getClass().getName());
                }
                if (!(before2 instanceof Point)) {
                    throw new IllegalArgumentException("The before value of a " + (Object)((Object)type2) + " event be a Point was " + this.before.getClass().getName());
                }
                if (after2 instanceof Point) break;
                throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be " + "be a Point was " + after2.getClass().getName());
            }
            case REMOVE_GEOMS: {
                if (!(source2 instanceof EditBlackboard)) {
                    throw new IllegalArgumentException("The source of a " + (Object)((Object)type2) + " event must be a " + "EditBlackboard was " + source2.getClass().getName());
                }
                if (!(before2 instanceof Collection)) {
                    throw new IllegalArgumentException("The before value of a " + (Object)((Object)type2) + " event be a EditGeom was " + this.before.getClass().getName());
                }
                if (after2 == null) break;
                throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be null");
            }
            case REMOVE_POINT: {
                if (!(source2 instanceof Set)) {
                    throw new IllegalArgumentException("The source of a " + (Object)((Object)type2) + " event must be a " + "Set was " + source2.getClass().getName());
                }
                if (!(before2 instanceof Point)) {
                    throw new IllegalArgumentException("The before value of a " + (Object)((Object)type2) + " event be a Point was " + this.before.getClass().getName());
                }
                if (after2 == null) break;
                throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be null");
            }
            case SET_GEOMS: {
                if (!(source2 instanceof EditBlackboard)) {
                    throw new IllegalArgumentException("The source of a " + (Object)((Object)type2) + " event must be a " + "EditBlackboard was " + source2.getClass().getName());
                }
                if (!(before2 instanceof Collection)) {
                    throw new IllegalArgumentException("The before value of a " + (Object)((Object)type2) + " event must be " + "be a Collection was " + before2.getClass().getName());
                }
                if (((Collection)before2).size() < 1) {
                    throw new IllegalArgumentException("The before value of a " + (Object)((Object)type2) + " event must be " + "be larger than 0");
                }
                for (Object obj : (Collection)before2) {
                    if (obj instanceof EditGeom) continue;
                    throw new IllegalArgumentException("The before value of a " + (Object)((Object)type2) + " event must be " + "be a Collection of EditGeoms found a " + obj.getClass().getName());
                }
                if (!(after2 instanceof Collection)) {
                    throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be " + "be a Collection was " + after2.getClass().getName());
                }
                if (((Collection)after2).size() < 1) {
                    throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be " + "be larger than 0");
                }
                for (Object obj : (Collection)after2) {
                    if (obj instanceof EditGeom) continue;
                    throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be " + "be a Collection of EditGeoms was " + obj.getClass().getName());
                }
                break;
            }
            case TRANFORMATION: {
                if (!(source2 instanceof EditBlackboard)) {
                    throw new IllegalArgumentException("The source of a " + (Object)((Object)type2) + " event must be a " + "EditBlackboard was " + source2.getClass().getName());
                }
                if (!(before2 instanceof AffineTransform)) {
                    throw new IllegalArgumentException("The before value of a " + (Object)((Object)type2) + " event be an Affine transform" + " but was :" + before2.getClass().getName());
                }
                if (after2 instanceof Map) break;
                throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be " + " a java.util.Map was: " + after2.getClass().getName());
            }
            case SELECTION: {
                if (source2 instanceof Selection) break;
                throw new IllegalArgumentException("The source of a " + (Object)((Object)type2) + " event must be a " + "Selection was " + source2.getClass().getName());
            }
            case ADD_POINT_TO_MANY: {
                if (!(source2 instanceof Collection)) {
                    throw new IllegalArgumentException("The source of a " + (Object)((Object)type2) + " event must be a " + "java.util.Collection was " + source2.getClass().getName());
                }
                for (Object obj : (Collection)source2) {
                    if (obj instanceof PrimitiveShape) continue;
                    throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be " + "be a Collection of EditGeoms was " + obj.getClass().getName());
                }
                if (before2 != null) {
                    throw new IllegalArgumentException("The before value of a " + (Object)((Object)type2) + " event be null");
                }
                if (after2 instanceof Point) break;
                throw new IllegalArgumentException("The after value of a " + (Object)((Object)type2) + " event must be " + " a Point was: " + after2.getClass().getName());
            }
        }
    }

    public Map<Point, List<Point>> getTransformationMap() {
        if (this.type != EventType.TRANFORMATION) {
            throw new IllegalStateException("Event must be a TRANSFORMATION event but was " + (Object)((Object)this.type));
        }
        return (Map)this.after;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " before: " + this.before + " after:" + this.after;
    }

    public EditBlackboard getEditBlackboard() {
        return this.editBlackboard;
    }

    public static enum EventType {
        ADD_POINT,
        REMOVE_POINT,
        MOVE_POINT,
        ADD_GEOMS,
        SET_GEOMS,
        REMOVE_GEOMS,
        TRANFORMATION,
        SELECTION,
        ADD_POINT_TO_MANY,
        CLEARED;

    }
}

