/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.ClosestEdge;
import net.refractions.udig.tools.edit.support.CoordResolvingList;
import net.refractions.udig.tools.edit.support.EditBlackboardEvent;
import net.refractions.udig.tools.edit.support.EditBlackboardListener;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditGeomSelection;
import net.refractions.udig.tools.edit.support.LazyCoord;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PointCoordCalculator;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.Selection;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.opengis.referencing.operation.MathTransform;

public class EditBlackboard {
    protected Map<Point, List<LazyCoord>> coordMapping;
    Map<Point, Set<EditGeom>> geomMapping;
    private final List<EditGeom> geometries;
    private Set<EditBlackboardListener> listeners = Collections.synchronizedSet(new HashSet());
    private Selection selection = new Selection(this);
    private volatile int height;
    private volatile int width;
    private boolean collapseVertices = true;
    PointCoordCalculator pointCoordCalculator;
    private volatile int batchingEvents = 0;
    private List<EditBlackboardEvent> batchedEvents = new LinkedList<EditBlackboardEvent>();

    public EditBlackboard(int width, int height, AffineTransform toScreen, MathTransform layerToMap) {
        this.width = width;
        this.height = height;
        this.coordMapping = new HashMap<Point, List<LazyCoord>>();
        this.geomMapping = new HashMap<Point, Set<EditGeom>>();
        this.pointCoordCalculator = new PointCoordCalculator(toScreen, layerToMap);
        this.geometries = new ArrayList<EditGeom>();
        this.geometries.add(new EditGeom(this, null));
    }

    public Set<EditBlackboardListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Geometry, EditGeom> setGeometries(Geometry geom, String featureId) {
        HashMap<Geometry, EditGeom> mapping = null;
        ArrayList<EditGeom> old = new ArrayList<EditGeom>(this.geometries);
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            this.geometries.clear();
            this.coordMapping.clear();
            this.geomMapping.clear();
            mapping = new HashMap<Geometry, EditGeom>();
            this.doAddGeometry(geom, mapping, featureId);
            if (EditPlugin.isDebugging("net.refractions.udig.tools.edit/debug/assertions")) {
                for (EditGeom geom2 : mapping.values()) {
                    geom2.assertValid();
                }
            }
        }
        if (mapping != null && !mapping.isEmpty()) {
            this.notify(new EditBlackboardEvent(this, this, EditBlackboardEvent.EventType.SET_GEOMS, old, new ArrayList<EditGeom>(this.geometries)));
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Geometry, EditGeom> addGeometry(Geometry geom, String featureID) {
        List unmodifiableList = null;
        HashMap<Geometry, EditGeom> mapping = null;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            mapping = new HashMap<Geometry, EditGeom>();
            this.doAddGeometry(geom, mapping, featureID);
            unmodifiableList = Collections.unmodifiableList(new ArrayList(mapping.values()));
            if (EditPlugin.isDebugging("net.refractions.udig.tools.edit/debug/assertions")) {
                for (EditGeom geom2 : mapping.values()) {
                    geom2.assertValid();
                }
            }
        }
        if (unmodifiableList != null && !unmodifiableList.isEmpty()) {
            this.notify(new EditBlackboardEvent(this, this, EditBlackboardEvent.EventType.ADD_GEOMS, null, unmodifiableList));
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClosestEdge addToNearestEdge(int x, int y, EditGeom geom, boolean treatUnknownAsPolygon) throws IllegalArgumentException {
        EditBlackboardEvent editBlackboardEvent = null;
        ClosestEdge geomClosest = null;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            if (!this.geometries.contains(geom)) {
                throw new IllegalArgumentException("EditBlackboard does not contain EditGeom " + geom);
            }
            Point p = Point.valueOf(x, y);
            geomClosest = geom.getClosestEdge(p, treatUnknownAsPolygon);
            Coordinate toCoord = this.toCoord(p);
            LazyCoord lazyCoord = this.doInsertCoord(p, toCoord, geomClosest.indexOfPrevious + 1, geomClosest.part);
            geom.assertValid();
            editBlackboardEvent = new EditBlackboardEvent(this, geomClosest.part, EditBlackboardEvent.EventType.ADD_POINT, null, p);
            editBlackboardEvent.privateData = lazyCoord;
        }
        if (editBlackboardEvent != null) {
            this.notify(editBlackboardEvent);
        }
        return geomClosest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClosestEdge> addToNearestEdge(int x, int y, boolean treatUnknownAsPolygon) throws IllegalArgumentException {
        EditBlackboardEvent editBlackboardEvent;
        List<ClosestEdge> candidates;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            candidates = this.getCandidates(x, y, treatUnknownAsPolygon);
            Point p = Point.valueOf(x, y);
            Coordinate toCoord = this.toCoord(p);
            if (candidates.size() == 0) {
                EditGeom editGeom = this.getGeoms().get(0);
                LazyCoord lazyCoord = this.doAddCoord(p, toCoord, editGeom.getShell());
                editGeom.getShell().assertValid();
                editBlackboardEvent = new EditBlackboardEvent(this, editGeom.getShell(), EditBlackboardEvent.EventType.ADD_POINT, null, p);
                editBlackboardEvent.privateData = lazyCoord;
            } else {
                HashMap<EditGeom, PrimitiveShape> changed = new HashMap<EditGeom, PrimitiveShape>();
                for (ClosestEdge edge : candidates) {
                    EditGeom geom = edge.shape;
                    this.doInsertCoord(p, toCoord, edge.indexOfPrevious + 1, edge.part);
                    changed.put(geom, edge.part);
                    edge.part.assertValid();
                }
                editBlackboardEvent = new EditBlackboardEvent(this, changed.values(), EditBlackboardEvent.EventType.ADD_POINT_TO_MANY, null, p);
            }
        }
        if (editBlackboardEvent != null) {
            this.notify(editBlackboardEvent);
        }
        return candidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coordinate addPoint(int x, int y, PrimitiveShape shape) throws IllegalArgumentException {
        LazyCoord lazyCoord = null;
        EditBlackboardEvent editBlackboardEvent = null;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            if (!this.geometries.contains(shape.getEditGeom())) {
                throw new IllegalArgumentException("Blackboard does not contain shape:" + shape);
            }
            Point point = Point.valueOf(x, y);
            Coordinate coord = this.toCoord(point);
            lazyCoord = this.doAddCoord(point, coord, shape);
            shape.assertValid();
            editBlackboardEvent = new EditBlackboardEvent(this, shape, EditBlackboardEvent.EventType.ADD_POINT, null, point);
            editBlackboardEvent.privateData = lazyCoord;
        }
        if (editBlackboardEvent != null) {
            this.notify(editBlackboardEvent);
        }
        return lazyCoord;
    }

    public Point addCoordinate(Coordinate coord, PrimitiveShape shape) {
        return this.insertCoordinate(coord, shape.getNumPoints(), shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point insertCoordinate(Coordinate coord, int index, PrimitiveShape shape) {
        EditBlackboardEvent editBlackboardEvent = null;
        Point p = null;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            if (!this.geometries.contains(shape.getEditGeom())) {
                throw new IllegalArgumentException("Blackboard does not contain shape:" + shape);
            }
            p = this.toPoint(coord);
            LazyCoord lazyCoord = this.doInsertCoord(p, coord, index, shape);
            shape.assertValid();
            editBlackboardEvent = new EditBlackboardEvent(this, shape, EditBlackboardEvent.EventType.ADD_POINT, null, p);
            editBlackboardEvent.privateData = lazyCoord;
        }
        if (editBlackboardEvent != null) {
            this.notify(editBlackboardEvent);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coordinate insertCoord(int x, int y, int pointIndex, PrimitiveShape shape) throws IllegalArgumentException {
        EditBlackboardEvent editBlackboardEvent = null;
        Coordinate coord = null;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            if (!this.geometries.contains(shape.getEditGeom())) {
                throw new IllegalArgumentException("Blackboard does not contain shape:" + shape);
            }
            Point point = Point.valueOf(x, y);
            coord = this.toCoord(point);
            LazyCoord lazyCoord = this.doInsertCoord(point, coord, pointIndex, shape);
            shape.assertValid();
            editBlackboardEvent = new EditBlackboardEvent(this, shape, EditBlackboardEvent.EventType.ADD_POINT, null, point);
            editBlackboardEvent.privateData = lazyCoord;
        }
        if (editBlackboardEvent != null) {
            this.notify(editBlackboardEvent);
        }
        return coord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCoords(int pointIndex, Point p, List<Coordinate> coords, PrimitiveShape shape) {
        List<LazyCoord> lazyCoords = null;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            if (!this.geometries.contains(shape.getEditGeom())) {
                throw new IllegalArgumentException("Blackboard does not contain shape:" + shape);
            }
            if (coords.isEmpty()) {
                throw new IllegalArgumentException("Coordinates cannot be empty");
            }
            lazyCoords = shape.getMutator().addPoint(pointIndex, p, coords);
            List<LazyCoord> mappedCoords = this.coordMapping.get(p);
            if (mappedCoords == null) {
                mappedCoords = new ArrayList<LazyCoord>();
                this.coordMapping.put(p, mappedCoords);
            }
            mappedCoords.addAll(lazyCoords);
            Set<EditGeom> geoms = this.geomMapping.get(p);
            if (geoms == null) {
                geoms = new HashSet<EditGeom>();
                this.geomMapping.put(p, geoms);
            }
            if (!geoms.contains(shape.getEditGeom())) {
                geoms.add(shape.getEditGeom());
            }
            if (EditPlugin.isDebugging("net.refractions.udig.tools.edit/debug/assertions")) {
                for (EditGeom geom : geoms) {
                    geom.assertValid();
                }
            }
        }
        EditBlackboardEvent editBlackboardEvent = new EditBlackboardEvent(this, shape, EditBlackboardEvent.EventType.ADD_POINT, null, p);
        editBlackboardEvent.privateData = lazyCoords;
        if (lazyCoords != null && !lazyCoords.isEmpty()) {
            this.notify(editBlackboardEvent);
        }
    }

    public synchronized List<ClosestEdge> getCandidates(int x, int y, boolean treatUnknownAsPolygon) {
        Point p = Point.valueOf(x, y);
        List<EditGeom> geoms = this.getGeoms();
        ArrayList<ClosestEdge> candidates = new ArrayList<ClosestEdge>();
        int closest = Integer.MAX_VALUE;
        ArrayList<ClosestEdge> closestDistances = new ArrayList<ClosestEdge>();
        int i = 0;
        while (i < geoms.size()) {
            ClosestEdge geomClosest = geoms.get(i).getClosestEdge(p, treatUnknownAsPolygon);
            if (geomClosest != null) {
                if (geomClosest.distanceToEdge < (double)closest) {
                    closest = (int)geomClosest.distanceToEdge;
                }
                closestDistances.add(geomClosest);
            }
            ++i;
        }
        for (ClosestEdge edge : closestDistances) {
            if ((int)edge.distanceToEdge != closest || edge.part.getMutator().hasPoint(edge.pointOnLine)) continue;
            candidates.add(edge);
        }
        return candidates;
    }

    public synchronized List<Coordinate> getCoords(int x, int y) {
        Point point = Point.valueOf(x, y);
        List<LazyCoord> list = this.coordMapping.get(point);
        if (list == null) {
            return Collections.emptyList();
        }
        return new CoordResolvingList(list, point);
    }

    public synchronized List<EditGeom> getGeoms() {
        return Collections.unmodifiableList(new ArrayList<EditGeom>(this.geometries));
    }

    public synchronized List<EditGeom> getGeoms(int x, int y) {
        Set<EditGeom> geoms = this.geomMapping.get(Point.valueOf(x, y));
        if (geoms == null) {
            return Collections.emptyList();
        }
        return new ArrayList<EditGeom>(geoms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Coordinate> moveCoords(int x, int y, int endX, int endY) {
        HashSet<PrimitiveShape> changed = new HashSet<PrimitiveShape>();
        List<LazyCoord> coords = null;
        Point start = Point.valueOf(x, y);
        Point end = Point.valueOf(endX, endY);
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            if (start.equals(end)) {
                return Collections.emptyList();
            }
            coords = this.coordMapping.remove(start);
            if (coords == null || coords.size() == 0) {
                return Collections.emptyList();
            }
            List<LazyCoord> endCoords = this.coordMapping.get(end);
            if (endCoords != null) {
                endCoords.addAll(coords);
            } else {
                this.coordMapping.put(end, coords);
            }
            Set<EditGeom> startGeoms = this.geomMapping.get(start);
            HashSet<EditGeom> endGeoms = this.geomMapping.get(end);
            endGeoms = endGeoms == null ? new HashSet<EditGeom>() : endGeoms;
            for (EditGeom geom : startGeoms) {
                geom.setChanged(true);
                if (!endGeoms.contains(geom)) {
                    endGeoms.add(geom);
                }
                for (PrimitiveShape hole : geom) {
                    Iterator iter = hole.getMutator().iterator();
                    block5: while (iter.hasNext()) {
                        Point p = (Point)iter.next();
                        if (!p.equals(start)) continue;
                        changed.add(hole);
                        for (LazyCoord coord : coords) {
                            if (!hole.hasVertex(p, coord)) continue;
                            iter.set(end);
                            continue block5;
                        }
                    }
                }
            }
            this.geomMapping.put(end, endGeoms);
            this.geomMapping.remove(start);
            if (EditPlugin.isDebugging("net.refractions.udig.tools.edit/debug/assertions")) {
                for (PrimitiveShape shape : changed) {
                    shape.assertValid();
                }
            }
        }
        if (!changed.isEmpty()) {
            this.notify(new EditBlackboardEvent(this, changed, EditBlackboardEvent.EventType.MOVE_POINT, start, end));
        }
        return new CoordResolvingList(coords, end);
    }

    public void moveSelection(int diffX, int diffY, Selection selection) {
        if (selection instanceof EditGeomSelection) {
            this.moveGeom(diffX, diffY, ((EditGeomSelection)selection).getGeom());
        } else {
            this.doMoveSelection(diffX, diffY, selection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMoveSelection(int diffX, int diffY, Selection selection2) {
        if (diffX == 0 && diffY == 0) {
            return;
        }
        if (this.selection.size() == 0) {
            return;
        }
        this.startBatchingEvents();
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            for (Point start : this.selection) {
                Collection<LazyCoord> coords = this.selection.getLazyCoordinates(start);
                Point end = Point.valueOf(start.getX() + diffX, start.getY() + diffY);
                List<LazyCoord> endCoords = this.coordMapping.get(end);
                this.coordMapping.get(start).removeAll(coords);
                if (endCoords != null) {
                    endCoords.addAll(coords);
                } else {
                    this.coordMapping.put(end, new LinkedList<LazyCoord>(coords));
                }
                Set<EditGeom> startGeoms = this.geomMapping.get(start);
                HashSet endGeoms = this.geomMapping.get(end);
                HashSet<PrimitiveShape> changed = new HashSet<PrimitiveShape>();
                if (startGeoms == null) continue;
                endGeoms = endGeoms == null ? new HashSet() : endGeoms;
                HashSet<EditGeom> toRemove = new HashSet<EditGeom>();
                HashSet<EditGeom> toAdd = new HashSet<EditGeom>();
                for (EditGeom geom : startGeoms) {
                    geom.setChanged(true);
                    for (PrimitiveShape shape : geom) {
                        Iterator<Point> shapeIter = shape.getMutator().getCopyIterator();
                        while (shapeIter.hasNext()) {
                            Point p = shapeIter.next();
                            if (!p.equals(start)) continue;
                            toAdd.add(geom);
                            for (LazyCoord coord : coords) {
                                if (!shape.hasVertex(p, coord)) continue;
                                changed.add(shape);
                                shape.getMutator().move(start, end, coord);
                            }
                        }
                        if (!shape.getMutator().getLazyCoordsAt(start).isEmpty()) continue;
                        toRemove.add(geom);
                    }
                    if (changed.isEmpty()) continue;
                    this.notify(new EditBlackboardEvent(this, changed, EditBlackboardEvent.EventType.MOVE_POINT, start, end));
                }
                endGeoms.addAll(toAdd);
                startGeoms.removeAll(toRemove);
                this.geomMapping.put(end, endGeoms);
                if (!EditPlugin.isDebugging("net.refractions.udig.tools.edit/debug/assertions")) continue;
                for (EditGeom geom : endGeoms) {
                    geom.assertValid();
                }
            }
        }
        this.fireBatchedEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveGeom(int deltaX, int deltaY, EditGeom geom) {
        if (!this.geometries.contains(geom)) {
            throw new IllegalArgumentException("Blackboard does not contain EditGeom:" + geom);
        }
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            HashSet<Point> moved = new HashSet<Point>();
            HashMap<Point, List<LazyCoord>> newCoordMapping = new HashMap<Point, List<LazyCoord>>();
            this.startBatchingEvents();
            for (PrimitiveShape primitiveShape : geom) {
                for (Point point : primitiveShape) {
                    if (moved.contains(point)) continue;
                    moved.add(point);
                    Point destPoint = Point.valueOf(point.getX() + deltaX, point.getY() + deltaY);
                    List<LazyCoord> coords = primitiveShape.getMutator().getLazyCoordsAt(point);
                    this.coordMapping.get(point).removeAll(coords);
                    newCoordMapping.put(destPoint, coords);
                    this.geomMapping.get(point).remove(geom);
                    this.notify(new EditBlackboardEvent(this, Collections.singleton(primitiveShape), EditBlackboardEvent.EventType.MOVE_POINT, point, destPoint));
                }
            }
            for (PrimitiveShape primitiveShape : geom) {
                primitiveShape.getMutator().move(deltaX, deltaY);
            }
            for (Map.Entry entry : newCoordMapping.entrySet()) {
                List<LazyCoord> destCoords = this.coordMapping.get(entry.getKey());
                if (destCoords == null) {
                    destCoords = new ArrayList<LazyCoord>();
                    this.coordMapping.put((Point)entry.getKey(), destCoords);
                }
                destCoords.addAll((Collection)entry.getValue());
                Set<EditGeom> destGeoms = this.geomMapping.get(entry.getKey());
                if (destGeoms == null) {
                    destGeoms = new HashSet<EditGeom>();
                    destGeoms.add(geom);
                    this.geomMapping.put((Point)entry.getKey(), destGeoms);
                    continue;
                }
                if (destGeoms.contains(geom)) continue;
                destGeoms.add(geom);
            }
            geom.assertValid();
            geom.setChanged(true);
        }
        this.fireBatchedEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Coordinate> removeCoordsAtPoint(int x, int y) {
        Point p = Point.valueOf(x, y);
        HashSet<PrimitiveShape> changed = new HashSet<PrimitiveShape>();
        CoordResolvingList result = null;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            List<LazyCoord> coords = this.coordMapping.remove(p);
            result = coords == null ? Collections.emptyList() : new CoordResolvingList(coords, p);
            Set<EditGeom> geoms = this.geomMapping.remove(p);
            if (geoms == null) {
                return Collections.emptyList();
            }
            for (EditGeom geom : geoms) {
                for (PrimitiveShape part : geom) {
                    PrimitiveShape.Mutator mutator = part.getMutator();
                    if (mutator.remove(p)) {
                        changed.add(part);
                    }
                    while (mutator.remove(p)) {
                    }
                }
            }
            if (EditPlugin.isDebugging("net.refractions.udig.tools.edit/debug/assertions")) {
                for (PrimitiveShape shape : changed) {
                    shape.assertValid();
                }
            }
        }
        if (!changed.isEmpty()) {
            this.notify(new EditBlackboardEvent(this, changed, EditBlackboardEvent.EventType.REMOVE_POINT, p, null));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCoords(int x, int y, PrimitiveShape shape) {
        Point p = Point.valueOf(x, y);
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            shape.getMutator().remove(p);
            Set<EditGeom> geoms = this.geomMapping.get(p);
            if (geoms.isEmpty()) {
                throw new IllegalStateException("for some reason there was no shape at the location");
            }
            boolean noMoreReferences = true;
            for (PrimitiveShape shape2 : shape.getEditGeom()) {
                if (shape2.getMutator().getLazyCoordsAt(p).isEmpty()) continue;
                noMoreReferences = false;
                break;
            }
            if (noMoreReferences) {
                geoms.remove(shape.getEditGeom());
            }
            shape.assertValid();
        }
        this.notify(new EditBlackboardEvent(this, Collections.singleton(shape), EditBlackboardEvent.EventType.REMOVE_POINT, p, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCoordinate(int pointIndex, Coordinate coord, PrimitiveShape shape) {
        if (!this.geometries.contains(shape.getEditGeom())) {
            throw new IllegalArgumentException("Blackboard does not contain shape:" + shape);
        }
        Point toRemove = null;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            toRemove = shape.getPoint(pointIndex);
            PrimitiveShape.Mutator mutator = shape.getMutator();
            LazyCoord removed = mutator.removePoint(pointIndex, coord);
            boolean occupiesPoint = false;
            for (Point point : mutator) {
                if (!point.equals(toRemove)) continue;
                occupiesPoint = true;
            }
            List<LazyCoord> coords = this.coordMapping.get(toRemove);
            Iterator<LazyCoord> iter = coords.iterator();
            while (iter.hasNext()) {
                if (iter.next() != removed) continue;
                iter.remove();
            }
            if (coords.isEmpty()) {
                this.coordMapping.remove(toRemove);
            }
            if (!occupiesPoint) {
                Set<EditGeom> geoms = this.geomMapping.get(toRemove);
                geoms.remove(shape.getEditGeom());
                if (geoms.isEmpty()) {
                    this.geomMapping.remove(toRemove);
                }
            }
            shape.assertValid();
        }
        if (toRemove != null) {
            this.notify(new EditBlackboardEvent(this, Collections.singleton(shape), EditBlackboardEvent.EventType.REMOVE_POINT, toRemove, null));
        }
    }

    public synchronized Coordinate toCoord(Point point) {
        return this.pointCoordCalculator.toCoord(point);
    }

    public synchronized Point toPoint(Coordinate coord) {
        return this.pointCoordCalculator.toPoint(coord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToScreenTransform(AffineTransform newToScreen) {
        AffineTransform oldToScreen = null;
        HashMap<? extends Point, ? extends List<Point>> map = new HashMap<Point, List<Point>>();
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            if (newToScreen.equals(this.pointCoordCalculator.toScreen)) {
                return;
            }
            oldToScreen = new AffineTransform(this.pointCoordCalculator.toScreen);
            AffineTransform oldToWorld = new AffineTransform(this.pointCoordCalculator.toWorld);
            this.geomMapping.clear();
            this.coordMapping.clear();
            PointCoordCalculator calculator = new PointCoordCalculator(newToScreen, this.pointCoordCalculator.layerToMap);
            for (EditGeom geom : this.geometries) {
                for (PrimitiveShape shape : geom) {
                    map.putAll(shape.getMutator().transform(oldToScreen, oldToWorld, calculator));
                }
            }
            this.pointCoordCalculator.toScreen.setTransform(newToScreen);
            this.pointCoordCalculator.toWorld.setTransform(calculator.toWorld);
            if (EditPlugin.isDebugging("net.refractions.udig.tools.edit/debug/assertions")) {
                for (EditGeom geom : this.geometries) {
                    geom.assertValid();
                }
            }
        }
        this.notify(new EditBlackboardEvent(this, this, EditBlackboardEvent.EventType.TRANFORMATION, new AffineTransform(oldToScreen), map));
    }

    public Selection getSelection() {
        return this.selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EditBlackboardEvent event = null;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            event = new EditBlackboardEvent(this, this, EditBlackboardEvent.EventType.REMOVE_GEOMS, new ArrayList<EditGeom>(this.geometries), null);
            this.coordMapping.clear();
            this.geometries.clear();
            this.geomMapping.clear();
            this.geometries.add(new EditGeom(this, null));
            this.selection.doClear();
        }
        this.notify(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EditGeom> removeGeometries(Collection<EditGeom> geomsToRemove) {
        ArrayList<EditGeom> removed = new ArrayList<EditGeom>();
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            for (EditGeom geom : geomsToRemove) {
                if (!this.geometries.contains(geom)) continue;
                removed.add(geom);
                for (PrimitiveShape shape : geom) {
                    int i = 0;
                    while (i < shape.getNumPoints()) {
                        Point point = shape.getPoint(i);
                        List<LazyCoord> coords = shape.getMutator().getLazyCoordsAt(i);
                        this.coordMapping.get(point).removeAll(coords);
                        this.geomMapping.get(point).remove(geom);
                        ++i;
                    }
                }
            }
            this.geometries.removeAll(geomsToRemove);
        }
        this.notify(new EditBlackboardEvent(this, this, EditBlackboardEvent.EventType.REMOVE_GEOMS, removed, null));
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditGeom newGeom(String featureId, ShapeType type) {
        EditGeom editGeom = new EditGeom(this, featureId);
        if (type != null) {
            editGeom.setShapeType(type);
        }
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            if (!this.geometries.isEmpty() && !this.geometries.get(0).isChanged() && this.geometries.get(0).getShell().getNumPoints() == 0) {
                this.geometries.clear();
            }
            this.geometries.add(editGeom);
        }
        this.notify(new EditBlackboardEvent(this, this, EditBlackboardEvent.EventType.ADD_GEOMS, null, Collections.singletonList(editGeom)));
        return editGeom;
    }

    public synchronized int getHeight() {
        return this.height;
    }

    public synchronized void setHeight(int height) {
        this.height = height;
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public synchronized void setWidth(int width) {
        this.width = width;
    }

    public synchronized boolean isCollapseVertices() {
        return this.collapseVertices;
    }

    public synchronized void setCollapseVertices(boolean collapseVertices) {
        this.collapseVertices = collapseVertices;
    }

    public Point overVertex(Point location, int radius) {
        return this.overVertex(location, radius, false);
    }

    public synchronized Point overVertex(Point location, int radius, boolean ignore) {
        if (!ignore && this.getCoords(location.getX(), location.getY()).size() != 0) {
            return location;
        }
        int i = 1;
        while (i <= radius) {
            Point result = this.findVertex(location, i);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public synchronized void startBatchingEvents() {
        ++this.batchingEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBatchedEvents() {
        List<EditBlackboardEvent> events;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            --this.batchingEvents;
            if (this.batchingEvents > 0) {
                return;
            }
            events = this.batchedEvents;
            this.batchedEvents = new LinkedList<EditBlackboardEvent>();
        }
        if (events.isEmpty()) {
            return;
        }
        EditBlackboardListener[] l = this.listeners.toArray(new EditBlackboardListener[0]);
        this.startBatchingEvents();
        try {
            EditBlackboardListener[] editBlackboardListenerArray = l;
            int n = l.length;
            int n2 = 0;
            while (n2 < n) {
                EditBlackboardListener listener = editBlackboardListenerArray[n2];
                listener.batchChange(events);
                ++n2;
            }
        }
        finally {
            this.fireBatchedEvents();
        }
    }

    private LazyCoord doAddCoord(Point p, Coordinate c, PrimitiveShape hole) {
        int index = hole.getNumPoints();
        return this.doInsertCoord(p, c, index, hole);
    }

    private LazyCoord doInsertCoord(Point point, Coordinate c, int pointIndex, PrimitiveShape hole) {
        Point p;
        if (hole == null || c == null || point == null) {
            throw new IllegalArgumentException("hole=" + hole + " coordIndex=" + pointIndex + " c=" + c + " p=" + point);
        }
        Point overLappingPoint = null;
        if (this.collapseVertices) {
            overLappingPoint = this.overVertex(point, PreferenceUtil.instance().getVertexRadius());
        }
        if ((p = overLappingPoint) == null || !this.collapseVertices) {
            p = point;
        }
        Coordinate coord = new Coordinate(c);
        List<LazyCoord> added = hole.getMutator().addPoint(pointIndex, p, Collections.singletonList(coord));
        LazyCoord lazyCoord = (LazyCoord)((Object)added.iterator().next());
        Set<EditGeom> geomList = this.updateMappings(p, lazyCoord);
        if (!geomList.contains(hole.getEditGeom())) {
            geomList.add(hole.getEditGeom());
        }
        return lazyCoord;
    }

    private Set<EditGeom> updateMappings(Point p, LazyCoord c) {
        List<LazyCoord> coordList = this.coordMapping.get(p);
        Set<EditGeom> geomList = this.geomMapping.get(p);
        if (coordList == null) {
            coordList = new ArrayList<LazyCoord>();
            geomList = new HashSet<EditGeom>();
            this.coordMapping.put(p, coordList);
            this.geomMapping.put(p, geomList);
        }
        coordList.add(c);
        return geomList;
    }

    private void doAddGeometry(Geometry geom, Map<Geometry, EditGeom> jtsEditGeomMapping, String featureID) {
        Envelope bbox = geom.getEnvelopeInternal();
        if (geom instanceof GeometryCollection) {
            int num = geom.getNumGeometries();
            int i = 0;
            while (i < num) {
                this.doAddGeometry(geom.getGeometryN(i), jtsEditGeomMapping, featureID);
                ++i;
            }
        } else {
            EditGeom geomShape = new EditGeom(this, featureID, bbox);
            geomShape.initializing = true;
            geomShape.setShapeType(ShapeType.valueOf(geom));
            this.geometries.add(geomShape);
            jtsEditGeomMapping.put(geom, geomShape);
            if (geom instanceof Polygon) {
                Polygon poly = (Polygon)geom;
                this.addShell((Geometry)poly.getExteriorRing(), geomShape);
                int i = 0;
                int numHoles = poly.getNumInteriorRing();
                while (i < numHoles) {
                    this.addHole((Geometry)poly.getInteriorRingN(i), geomShape, i);
                    ++i;
                }
            } else {
                this.addShell(geom, geomShape);
            }
            geomShape.initializing = false;
            if (geomShape.isChanged()) {
                geomShape.setChanged(false);
            }
        }
    }

    private void addHole(Geometry geom, EditGeom geomShape, int holeIndex) {
        PrimitiveShape hole = holeIndex == geomShape.getHoles().size() ? geomShape.newHole() : geomShape.getHoles().get(holeIndex);
        Coordinate[] coords = geom.getCoordinates();
        int i = 0;
        while (i < coords.length) {
            this.doAddCoord(this.toPoint(coords[i]), coords[i], hole);
            ++i;
        }
    }

    private void addShell(Geometry geom, EditGeom editGeom) {
        Coordinate[] coords = geom.getCoordinates();
        int i = 0;
        while (i < coords.length) {
            this.doAddCoord(this.toPoint(coords[i]), coords[i], editGeom.getShell());
            editGeom.getShell().assertValid();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(EditBlackboardEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        EditBlackboardListener[] l = null;
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            if (this.batchingEvents > 0) {
                this.batchedEvents.add(event);
            } else {
                l = this.listeners.toArray(new EditBlackboardListener[0]);
            }
        }
        if (l != null) {
            EditBlackboardListener[] editBlackboardListenerArray = l;
            int n = l.length;
            int n2 = 0;
            while (n2 < n) {
                EditBlackboardListener listener = editBlackboardListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
        }
    }

    private Point findVertex(Point location, int i) {
        int maxX = location.getX() + i;
        int maxY = location.getY() + i;
        int minX = location.getX() - i;
        int minY = location.getY() - i;
        int x = minX;
        while (x <= maxX) {
            if (this.getCoords(x, minY).size() > 0) {
                return Point.valueOf(x, minY);
            }
            ++x;
        }
        int y = minY + 1;
        while (y <= maxY) {
            if (this.getCoords(maxX, y).size() > 0) {
                return Point.valueOf(maxX, y);
            }
            ++y;
        }
        x = maxX - 1;
        while (x >= minX) {
            if (this.getCoords(x, maxY).size() > 0) {
                return Point.valueOf(x, maxY);
            }
            --x;
        }
        y = maxY - 1;
        while (y >= minY) {
            if (this.getCoords(minX, y).size() > 0) {
                return Point.valueOf(minX, y);
            }
            --y;
        }
        return null;
    }

    public boolean selectionAdd(Point point) {
        return this.selection.doAdd(point);
    }

    public boolean selectionAddAll(Collection<Point> points) {
        return this.selection.doAddAll(points);
    }

    public void selectionClear() {
        this.selection.doClear();
    }

    public boolean selectionRemoveAll(Collection<Point> points) {
        return this.selection.doRemoveAll(points, true);
    }

    public boolean selectionRemove(Point point) {
        return this.selection.doRemove(point);
    }

    public boolean selectionRetainAll(Collection<Point> points) {
        return this.selection.doRetainAll(points);
    }

    public boolean contains(String fid) {
        List<EditGeom> geoms = this.getGeoms();
        for (EditGeom geom : geoms) {
            if (!geom.getFeatureIDRef().toString().equals(fid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapLayerTransform(MathTransform mapToLayer) {
        AffineTransform oldToScreen = null;
        HashMap<? extends Point, ? extends List<Point>> map = new HashMap<Point, List<Point>>();
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            if (mapToLayer.equals(this.pointCoordCalculator.mapToLayer)) {
                return;
            }
            oldToScreen = new AffineTransform(this.pointCoordCalculator.toScreen);
            AffineTransform oldToWorld = new AffineTransform(this.pointCoordCalculator.toWorld);
            this.geomMapping.clear();
            this.coordMapping.clear();
            PointCoordCalculator calculator = new PointCoordCalculator(this.pointCoordCalculator.toScreen, mapToLayer);
            for (EditGeom geom : this.geometries) {
                for (PrimitiveShape shape : geom) {
                    map.putAll(shape.getMutator().transform(oldToScreen, oldToWorld, calculator));
                }
            }
            this.pointCoordCalculator.setMapToLayer(mapToLayer);
            if (EditPlugin.isDebugging("net.refractions.udig.tools.edit/debug/assertions")) {
                for (EditGeom geom : this.geometries) {
                    geom.assertValid();
                }
            }
        }
        this.notify(new EditBlackboardEvent(this, this, EditBlackboardEvent.EventType.TRANFORMATION, oldToScreen, map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoords(Point point, Coordinate newValue) {
        EditBlackboard editBlackboard = this;
        synchronized (editBlackboard) {
            if (!this.toPoint(newValue).equals(point)) {
                throw new IllegalArgumentException("newValue has to map to point.  newValue maps to: " + this.toPoint(newValue) + " but should map to" + point);
            }
            List<LazyCoord> coords = this.coordMapping.get(point);
            if (coords != null) {
                for (LazyCoord coord : coords) {
                    coord.get(point);
                    coord.coord = newValue;
                    coord.x = newValue.x;
                    coord.y = newValue.y;
                    coord.z = newValue.z;
                }
            } else {
                throw new NullPointerException("No points associated with " + point);
            }
        }
    }

    public boolean isEmpty() {
        return this.geomMapping.isEmpty();
    }
}

