/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import java.awt.Shape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditBlackboardAdapter;
import net.refractions.udig.tools.edit.support.EditBlackboardEvent;
import net.refractions.udig.tools.edit.support.EditBlackboardListener;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditGeomPathIterator;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;

public class CurrentEditGeomPathIterator
extends EditGeomPathIterator {
    private Point location;
    State currentState;
    private PrimitiveShape shape;
    private static final Map<EditBlackboard, EditBlackboardListener> listeners = new HashMap<EditBlackboard, EditBlackboardListener>();
    private static final Map<EditGeom, CurrentEditGeomPathIterator> map = new HashMap<EditGeom, CurrentEditGeomPathIterator>();

    protected CurrentEditGeomPathIterator(EditGeom shape) {
        super(shape);
    }

    public static CurrentEditGeomPathIterator getPathIterator(EditGeom geom) {
        CurrentEditGeomPathIterator iter = map.get(geom);
        if (iter == null) {
            iter = new CurrentEditGeomPathIterator(geom);
            EditBlackboardListener listener = listeners.get(geom.getEditBlackboard());
            if (listener == null) {
                listener = new EditBlackboardAdapter(){

                    @Override
                    public void changed(EditBlackboardEvent event) {
                        if (event.getType() == EditBlackboardEvent.EventType.REMOVE_GEOMS) {
                            List geoms = (List)event.getOldValue();
                            for (EditGeom geom : geoms) {
                                map.remove(geom);
                            }
                        }
                    }

                    @Override
                    public void batchChange(List<EditBlackboardEvent> e) {
                        for (EditBlackboardEvent event : e) {
                            this.changed(event);
                        }
                    }
                };
                listeners.put(geom.getEditBlackboard(), listener);
            }
            geom.getEditBlackboard().getListeners().add(listener);
            map.put(geom, iter);
        }
        return iter;
    }

    @Override
    public boolean isDone() {
        boolean superDone = super.isDone();
        return superDone && this.currentState == State.done;
    }

    private void prepareToPath() {
        this.currentState = this.location == null ? State.done : (this.shape.getNumPoints() == 0 ? State.onlyPointInShape : State.waiting);
    }

    @Override
    public Shape toShape() {
        this.prepareToPath();
        return super.toShape();
    }

    @Override
    public Path toPath(Device device) {
        this.prepareToPath();
        return super.toPath(device);
    }

    @Override
    protected Shape createPoint() {
        return null;
    }

    @Override
    protected Path createPointPath(Device device) {
        return null;
    }

    @Override
    public void next() {
        if (!super.isDone()) {
            super.next();
            return;
        }
        this.currentState = this.currentState == State.waiting ? State.onCurrent : State.done;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (!super.isDone()) {
            return super.currentSegment(coords);
        }
        if (this.currentState == State.onCurrent || this.currentState == State.onlyPointInShape) {
            coords[0] = this.location.getX();
            coords[1] = this.location.getY();
            if (this.currentState == State.onlyPointInShape) {
                return 0;
            }
        }
        if (this.currentState == State.done && this.isPolygon()) {
            return 4;
        }
        return 1;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point location, PrimitiveShape shape) {
        if (shape != null) {
            this.location = location;
            this.shape = shape;
        } else {
            this.location = null;
            this.shape = null;
        }
    }

    public static /* bridge */ /* synthetic */ EditGeomPathIterator getPathIterator(EditGeom editGeom) {
        return CurrentEditGeomPathIterator.getPathIterator(editGeom);
    }

    static enum State {
        waiting,
        onCurrent,
        done,
        onlyPointInShape;

    }
}

