/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.preferences;

import java.awt.Color;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.support.SnapBehaviour;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class PreferenceUtil {
    protected static PreferenceUtil instance = new PreferenceUtil();
    IPreferenceStore store = EditPlugin.getDefault().getPreferenceStore();
    Color drawGeomsFill = new Color(144, 255, 144, 100);

    protected PreferenceUtil() {
    }

    public static PreferenceUtil instance() {
        return instance;
    }

    public int getVertexRadius() {
        return this.store.getInt("P_VERTEX_SIZE");
    }

    public Color getDrawGeomsLine() {
        return this.getDrawSelectionFillColor();
    }

    public Color getDrawVertexLineColor() {
        return this.getColor((IPreferenceStore)ProjectPlugin.getPlugin().getPreferenceStore(), "P_SELECTION2_COLOR");
    }

    private Color getColor(IPreferenceStore store2, String preferenceID) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store2, (String)preferenceID);
        Color color = new Color(rgb.red, rgb.green, rgb.blue);
        return color;
    }

    public Color getDrawSelectionFillColor() {
        return this.getColor((IPreferenceStore)ProjectPlugin.getPlugin().getPreferenceStore(), "P_SELECTION_COLOR");
    }

    public void setSnappingRadius(int newRadius) {
        this.store.setValue("P_SNAP_RADIUS", newRadius);
    }

    public int getSnappingRadius() {
        return this.store.getInt("P_SNAP_RADIUS");
    }

    public Color getFeedbackColor() {
        return this.getColor(this.store, "P_SNAP_CIRCLE_COLOR");
    }

    public Color getSelectionColor() {
        return this.getColor((IPreferenceStore)ProjectPlugin.getPlugin().getPreferenceStore(), "P_SELECTION_COLOR");
    }

    public Color getDrawGeomsFill() {
        Color base = this.getSelectionColor();
        return PreferenceUtil.reduceTransparency(base, 0.35f);
    }

    public static Color reduceTransparency(Color base, float factor) {
        float alpha = base.getAlpha();
        int i = Math.round(alpha * factor);
        Color color = new Color(base.getRed(), base.getGreen(), base.getBlue(), i);
        return color;
    }

    public Color getDrawVertexFillColor() {
        Color base = this.getSelectionColor();
        return PreferenceUtil.reduceTransparency(base, 0.35f);
    }

    public SnapBehaviour getSnapBehaviour() {
        String preference = this.store.getString("P_SNAP_OPERATION");
        if (preference.equals(SnapBehaviour.OFF.toString())) {
            return SnapBehaviour.OFF;
        }
        if (preference.equals(SnapBehaviour.SELECTED.toString())) {
            return SnapBehaviour.SELECTED;
        }
        if (preference.equals(SnapBehaviour.CURRENT_LAYER.toString())) {
            return SnapBehaviour.CURRENT_LAYER;
        }
        if (preference.equals(SnapBehaviour.ALL_LAYERS.toString())) {
            return SnapBehaviour.ALL_LAYERS;
        }
        if (preference.equals(SnapBehaviour.GRID.toString())) {
            return SnapBehaviour.GRID;
        }
        return SnapBehaviour.OFF;
    }

    public void setSnapBehaviour(SnapBehaviour behaviour) {
        this.store.setValue("P_SNAP_OPERATION", behaviour.toString());
    }

    public boolean hideSelectedLayers() {
        return this.store.getBoolean("P_HIDE_SELECTED_FEATURES");
    }

    public boolean isAdvancedEditingActive() {
        return this.store.getBoolean("P_ADVANCED_ACTIVE");
    }

    public void setAdvancedEditingActive(boolean b) {
        this.store.setValue("P_ADVANCED_ACTIVE", b);
    }

    public short getMessageDisplayDelay() {
        return 2000;
    }
}

