/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Point;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.internal.commands.draw.DrawShapeCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.AbstractModalTool;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditPlugin;
import org.eclipse.jface.action.IStatusLineManager;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;

public class DeleteTool
extends AbstractModalTool
implements ModalTool {
    DrawShapeCommand draw = new DrawShapeCommand();

    public DeleteTool() {
        super(3);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.setStatusBarMessage(active);
    }

    private void setStatusBarMessage(final boolean active) {
        this.getContext().updateUI(new Runnable(){

            @Override
            public void run() {
                if (DeleteTool.this.getContext().getActionBars() == null) {
                    return;
                }
                IStatusLineManager bar = DeleteTool.this.getContext().getActionBars().getStatusLineManager();
                if (bar != null) {
                    if (active) {
                        if (DeleteTool.this.getContext().getMapLayers().size() > 0) {
                            bar.setMessage(Messages.DeleteTool_status);
                        }
                    } else {
                        bar.setMessage("");
                    }
                    bar.setErrorMessage(null);
                }
            }
        });
    }

    public void mousePressed(MapMouseEvent e) {
        this.draw.setValid(true);
        this.context.sendASyncCommand((Command)this.draw);
        this.feedback(e);
    }

    public void mouseDragged(MapMouseEvent e) {
        this.feedback(e);
    }

    public void feedback(MapMouseEvent e) {
        ReferencedEnvelope box = this.context.getBoundingBox(new Point(e.x - 3, e.y - 3), 7);
        this.draw.setShape(this.context.toShape(box));
        this.context.getViewportPane().repaint();
        super.mouseDragged(e);
    }

    public void mouseReleased(MapMouseEvent e) {
        if (this.getContext().getMapLayers().size() == 0) {
            return;
        }
        FeatureIterator reader = null;
        try {
            ILayer layer = this.getContext().getEditManager().getSelectedLayer();
            if (layer == null) {
                layer = (ILayer)this.getContext().getMapLayers().get(0);
            }
            if (layer == null) {
                throw new Exception("No layers in map");
            }
            ReferencedEnvelope env = this.getContext().getBoundingBox(e.getPoint(), 6);
            FeatureCollection results = this.getContext().getFeaturesInBbox(layer, (Envelope)env);
            reader = results.features();
            final boolean found = !reader.hasNext();
            this.getContext().updateUI(new Runnable(){

                @Override
                public void run() {
                    if (DeleteTool.this.getContext().getActionBars() == null) {
                        return;
                    }
                    IStatusLineManager bar = DeleteTool.this.getContext().getActionBars().getStatusLineManager();
                    if (bar != null) {
                        if (found) {
                            bar.setErrorMessage(Messages.DeleteTool_warning);
                        } else {
                            bar.setErrorMessage(null);
                        }
                    }
                }
            });
            if (found) {
                return;
            }
            try {
                SimpleFeature feature = (SimpleFeature)reader.next();
                UndoableMapCommand deleteFeatureCommand = this.getContext().getEditFactory().createDeleteFeature(feature, layer);
                this.getContext().sendASyncCommand((Command)deleteFeatureCommand);
                this.getContext().getViewportPane().repaint();
            }
            catch (Exception e1) {
                EditPlugin.log(null, e1);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e2) {
                EditPlugin.log(null, e2);
            }
            this.draw.setValid(false);
            this.getContext().getViewportPane().repaint();
        }
    }
}

