/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands.selection;

import com.vividsolutions.jts.geom.Geometry;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.SelectFeatureAsEditFeatureCommand;
import net.refractions.udig.tools.edit.commands.SelectFeatureCommand;
import net.refractions.udig.tools.edit.commands.SelectionParameter;
import net.refractions.udig.tools.edit.commands.SelectionStrategy;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.Point;
import org.eclipse.core.runtime.IProgressMonitor;
import org.opengis.feature.simple.SimpleFeature;

public class SelectFeatureStrategy
implements SelectionStrategy {
    @Override
    public void run(IProgressMonitor monitor, UndoableComposite commands, SelectionParameter parameters, SimpleFeature feature, boolean firstFeature) {
        EditToolHandler handler = parameters.handler;
        Class<? extends Geometry>[] acceptableClasses = parameters.acceptableClasses;
        boolean onlyAdd = parameters.onlyAdd;
        MapMouseEvent event = parameters.event;
        Class<? extends Geometry>[] classArray = acceptableClasses;
        int n = acceptableClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Geometry> clazz = classArray[n2];
            if (clazz.isAssignableFrom(feature.getDefaultGeometry().getClass())) {
                EditPlugin.trace("net.refractions.udig.tools.edit/selection", "Feature is one of the acceptable classes " + feature.getID(), null);
                if (firstFeature && !this.keyboardModifierIndicatesAdd(handler, event) && !onlyAdd) {
                    commands.addCommand((MapCommand)handler.getCommand(handler.getAcceptBehaviours()));
                    commands.addCommand((MapCommand)new SelectFeatureAsEditFeatureCommand(handler, feature, handler.getEditLayer(), Point.valueOf(event.x, event.y)));
                } else if (onlyAdd || this.keyboardModifierIndicatesAdd(handler, event)) {
                    commands.addCommand((MapCommand)new SelectFeatureCommand(handler, feature, Point.valueOf(event.x, event.y)));
                } else {
                    commands.addCommand((MapCommand)new SelectFeatureCommand(handler, feature, null));
                }
            } else {
                EditPlugin.trace("net.refractions.udig.tools.edit/selection", "Feature is not one of the acceptable classes " + feature.getID(), null);
            }
            ++n2;
        }
    }

    private boolean keyboardModifierIndicatesAdd(EditToolHandler handler, MapMouseEvent event) {
        EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
        boolean noIntersectingSelection = editBlackboard.getGeoms(event.x, event.y).isEmpty();
        return event.isShiftDown() || noIntersectingSelection && event.isModifierDown(MapMouseEvent.MOD1_DOWN_MASK);
    }
}

