/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;
import org.opengis.feature.simple.SimpleFeature;

public class SetCurrentGeomCommand
extends AbstractCommand
implements UndoableMapCommand {
    EditToolHandler handler;
    PrimitiveShape oldShape;
    PrimitiveShape newShape;
    private IBlockingProvider<PrimitiveShape> provider;
    private SimpleFeature oldEditFeature;
    private Layer oldEditLayer;

    public SetCurrentGeomCommand(EditToolHandler handler2, PrimitiveShape newShape2) {
        this.handler = handler2;
        this.newShape = newShape2;
    }

    public SetCurrentGeomCommand(EditToolHandler handler2, IBlockingProvider<PrimitiveShape> provider) {
        this.provider = provider;
        this.handler = handler2;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.oldEditFeature = this.getMap().getEditManager().getEditFeature();
        this.oldEditLayer = this.getMap().getEditManagerInternal().getEditLayerInternal();
        if (this.oldEditFeature != null) {
            this.getMap().getEditManagerInternal().setEditFeature(null, null);
        }
        if (this.oldShape == null) {
            this.oldShape = this.handler.getCurrentShape();
        }
        if (this.newShape == null && this.provider != null) {
            this.newShape = (PrimitiveShape)this.provider.get(monitor, new Object[0]);
        }
        this.handler.setCurrentShape(this.newShape);
    }

    public String getName() {
        return Messages.SetCurrentGeomCommand_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.handler.setCurrentShape(this.oldShape);
        this.getMap().getEditManagerInternal().setEditFeature(this.oldEditFeature, this.oldEditLayer);
    }
}

