/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import java.util.Collections;
import java.util.Set;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.Selection;
import org.eclipse.core.runtime.IProgressMonitor;

public class SelectVertexCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Type type;
    private Set<Point> points;
    private EditBlackboard editBlackboard;
    private Selection oldPoints;

    public SelectVertexCommand(EditBlackboard editBlackboard, Set<Point> points, Type type) {
        this.editBlackboard = editBlackboard;
        this.points = points;
        this.type = type;
    }

    public SelectVertexCommand(EditBlackboard editBlackboard2, Point point, Type type) {
        this(editBlackboard2, Collections.singleton(point), type);
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.editBlackboard.startBatchingEvents();
        this.oldPoints = new Selection(this.editBlackboard.getSelection());
        this.oldPoints.disconnect();
        if (this.type == Type.ADD) {
            this.editBlackboard.selectionAddAll(this.points);
        } else if (this.type == Type.SET) {
            this.editBlackboard.selectionClear();
            if (!this.points.isEmpty()) {
                this.editBlackboard.selectionAddAll(this.points);
            }
        } else if (!this.points.isEmpty()) {
            this.editBlackboard.selectionRemoveAll(this.points);
        }
        this.editBlackboard.fireBatchedEvents();
    }

    public String getName() {
        return Messages.SelectPointCommand_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(IProgressMonitor monitor) throws Exception {
        Selection selection;
        Selection selection2 = selection = this.editBlackboard.getSelection();
        synchronized (selection2) {
            this.editBlackboard.selectionClear();
            this.editBlackboard.selectionAddAll(this.oldPoints);
        }
    }

    public static enum Type {
        ADD,
        SET,
        REMOVE;

    }
}

