/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import java.util.ArrayList;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.commands.SelectFeatureCommand;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class SelectFeaturesInFilterCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Filter filter;
    private ILayer layer;
    private EditBlackboard bb;
    private ArrayList<UndoableMapCommand> commands;

    public SelectFeaturesInFilterCommand(EditBlackboard blackboard, ILayer layer, Filter filter) {
        if (!layer.hasResource(FeatureStore.class)) {
            throw new IllegalArgumentException("Layer must have a FeatureStore resource");
        }
        this.filter = filter;
        this.layer = layer;
        this.bb = blackboard;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.AddFeaturesCommand_taskMessage, 10);
        monitor.worked(1);
        FeatureStore store = (FeatureStore)this.layer.getResource(FeatureStore.class, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        String geomAttributeName = this.layer.getSchema().getGeometryDescriptor().getLocalName();
        String[] desiredProperties = new String[]{geomAttributeName};
        DefaultQuery query = new DefaultQuery(this.layer.getSchema().getTypeName(), this.filter, desiredProperties);
        FeatureCollection features = store.getFeatures((Query)query);
        FeatureIterator iter = features.features();
        try {
            this.commands = new ArrayList();
            while (iter.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iter.next();
                this.commands.add(new SelectFeatureCommand(this.bb, feature));
            }
            float index = 0.0f;
            float inc = 7.0f / (float)this.commands.size();
            for (UndoableMapCommand command : this.commands) {
                command.setMap((IMap)this.getMap());
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, (int)(index += inc));
                command.run((IProgressMonitor)subProgressMonitor);
                subProgressMonitor.done();
                if (!(index > 1.0f)) continue;
                index = 0.0f;
            }
        }
        finally {
            features.close(iter);
        }
        monitor.done();
    }

    public String getName() {
        return null;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.AddFeaturesCommand_undoTaskMessage, this.commands.size() * 2);
        int i = this.commands.size() - 1;
        while (i > -1) {
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 2);
            this.commands.get(i).rollback((IProgressMonitor)subProgressMonitor);
            subProgressMonitor.done();
            --i;
        }
        monitor.done();
    }
}

