/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.animation.AddVertexAnimation;
import net.refractions.udig.tools.edit.animation.DeleteVertexAnimation;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.Selection;
import net.refractions.udig.tools.edit.support.ShapeType;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.WaitCondition;
import org.eclipse.core.runtime.IProgressMonitor;

public class RemoveSelectedVerticesCommand
extends AbstractCommand
implements Command,
UndoableMapCommand {
    private EditToolHandler handler;
    private List<Bag> undoData;
    private boolean runAnimation;

    public RemoveSelectedVerticesCommand(EditToolHandler handler) {
        this.handler = handler;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        EditBlackboard blackboard = this.handler.getEditBlackboard(this.handler.getEditLayer());
        blackboard.startBatchingEvents();
        Selection selection = blackboard.getSelection();
        this.undoData = new ArrayList<Bag>();
        EditState oldState = this.handler.getCurrentState();
        try {
            this.handler.setCurrentState(EditState.BUSY);
            DeleteVertexAnimation deleteVertexAnimation = null;
            if (this.runAnimation) {
                for (Point point : selection) {
                    deleteVertexAnimation = new DeleteVertexAnimation(point);
                    AnimationUpdater.runTimer((IMapDisplay)this.handler.getContext().getMapDisplay(), (IAnimation)deleteVertexAnimation);
                }
                if (deleteVertexAnimation != null) {
                    final DeleteVertexAnimation finalDeleteVertexAnim = deleteVertexAnimation;
                    PlatformGIS.wait((long)deleteVertexAnimation.getFrameInterval(), (long)5000L, (WaitCondition)new WaitCondition(){

                        public boolean isTrue() {
                            return !finalDeleteVertexAnim.isValid();
                        }
                    }, null);
                }
            }
            HashSet<Point> points = new HashSet<Point>(selection);
            HashSet<EditGeom> allAffectedGeoms = new HashSet<EditGeom>();
            for (Point point : points) {
                allAffectedGeoms.addAll(blackboard.getGeoms(point.getX(), point.getY()));
            }
            HashMap<PrimitiveShape, Integer> deletes = new HashMap<PrimitiveShape, Integer>();
            for (EditGeom geom : allAffectedGeoms) {
                for (PrimitiveShape shape : geom) {
                    int i = 0;
                    while (i < shape.getNumPoints()) {
                        Point shapePoint = shape.getPoint(i);
                        if (points.contains(shapePoint)) {
                            Bag bag = new Bag();
                            bag.p = shapePoint;
                            bag.coords = shape.getCoordsAt(i);
                            bag.shape = shape;
                            bag.index = i - RemoveSelectedVerticesCommand.get(deletes, shape);
                            bag.action = Action.REMOVE;
                            this.increment(deletes, shape);
                            this.undoData.add(bag);
                        }
                        ++i;
                    }
                }
            }
            for (Point point : points) {
                blackboard.removeCoordsAtPoint(point.getX(), point.getY());
            }
            for (PrimitiveShape shape : deletes.keySet()) {
                if (shape.getNumPoints() <= 0 || shape.getEditGeom().getShapeType() != ShapeType.POLYGON || shape.getPoint(0).equals(shape.getPoint(shape.getNumPoints() - 1))) continue;
                List<Coordinate> singletonList = Collections.singletonList(shape.getCoord(0));
                blackboard.addCoordinate(shape.getCoord(0), shape);
                Bag bag = new Bag();
                bag.p = shape.getPoint(shape.getNumPoints() - 1);
                bag.coords = singletonList;
                bag.shape = shape;
                bag.index = -1;
                bag.action = Action.ADD;
                this.undoData.add(bag);
            }
        }
        finally {
            this.handler.setCurrentState(oldState);
            blackboard.fireBatchedEvents();
        }
    }

    private void increment(Map<PrimitiveShape, Integer> deletes, PrimitiveShape shape) {
        if (!deletes.containsKey(shape)) {
            deletes.put(shape, 1);
        } else {
            int val = deletes.get(shape) + 1;
            deletes.put(shape, val);
        }
    }

    private static int get(Map<PrimitiveShape, Integer> deletes, PrimitiveShape shape) {
        if (deletes.containsKey(shape)) {
            return deletes.get(shape);
        }
        return 0;
    }

    public String getName() {
        return Messages.RemoveSelectedVerticesCommand_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        EditBlackboard blackboard = this.handler.getEditBlackboard(this.handler.getEditLayer());
        blackboard.startBatchingEvents();
        try {
            int i = this.undoData.size() - 1;
            while (i > -1) {
                Bag bag = this.undoData.get(i);
                switch (bag.action) {
                    case ADD: {
                        blackboard.removeCoordinate(bag.shape.getNumPoints() - 1, bag.coords.get(0), bag.shape);
                        break;
                    }
                    case REMOVE: {
                        if (this.runAnimation) {
                            AnimationUpdater.runTimer((IMapDisplay)this.handler.getContext().getMapDisplay(), (IAnimation)new AddVertexAnimation(bag.p.getX(), bag.p.getY()));
                        }
                        blackboard.insertCoords(bag.index, bag.p, bag.coords, bag.shape);
                        blackboard.selectionAdd(bag.p);
                        break;
                    }
                }
                --i;
            }
        }
        finally {
            blackboard.fireBatchedEvents();
        }
    }

    public void setRunAnimation(boolean run) {
        this.runAnimation = run;
    }

    static enum Action {
        ADD,
        REMOVE;

    }

    static class Bag {
        Action action;
        Point p;
        int index;
        List<Coordinate> coords;
        PrimitiveShape shape;

        Bag() {
        }

        public String toString() {
            return (Object)((Object)this.action) + " " + this.coords;
        }
    }
}

