/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Coordinate;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.animation.AddVertexAnimation;
import net.refractions.udig.tools.edit.animation.DeleteVertexAnimation;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.Selection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class InsertVertexCommand
extends AbstractCommand
implements UndoableMapCommand {
    private final Coordinate toAdd;
    private final IBlockingProvider<PrimitiveShape> shape;
    private final EditBlackboard board;
    private int index;
    private final IMapDisplay mapDisplay;
    private EditToolHandler handler;
    private Selection oldSelection;
    private Point point;

    public InsertVertexCommand(EditToolHandler handler, EditBlackboard board, IMapDisplay display, IBlockingProvider<PrimitiveShape> shape, Point toAdd, int index, boolean useSnapping) {
        this.board = board;
        this.shape = shape;
        this.index = index;
        this.mapDisplay = display;
        this.handler = handler;
        this.point = toAdd;
        this.toAdd = this.performSnapCalculation(toAdd, useSnapping);
    }

    private Coordinate performSnapCalculation(Point point, boolean useSnapping) {
        Coordinate toCoord = this.board.toCoord(point);
        if (useSnapping) {
            Coordinate newCoord = EditUtils.instance.getClosestSnapPoint(this.handler, this.board, point, false, PreferenceUtil.instance().getSnapBehaviour(), this.handler.getCurrentState());
            if (newCoord != null) {
                this.point = this.board.toPoint(newCoord);
                return newCoord;
            }
            return toCoord;
        }
        return toCoord;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.board.startBatchingEvents();
        if (this.handler.getContext().getMapDisplay() != null) {
            DeleteVertexAnimation animation = new DeleteVertexAnimation(this.point);
            AnimationUpdater.runTimer((IMapDisplay)this.handler.getContext().getMapDisplay(), (IAnimation)animation);
        }
        this.board.removeCoordinate(this.index, this.toAdd, (PrimitiveShape)this.shape.get((IProgressMonitor)new SubProgressMonitor(monitor, 1), new Object[0]));
        this.board.selectionClear();
        this.board.selectionAddAll(this.oldSelection);
        this.board.fireBatchedEvents();
        if (this.getMap() != null) {
            this.handler.repaint();
        }
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.board.startBatchingEvents();
        PrimitiveShape primitiveShape = (PrimitiveShape)this.shape.get((IProgressMonitor)new SubProgressMonitor(monitor, 1), new Object[0]);
        this.board.insertCoordinate(this.toAdd, this.index, primitiveShape);
        this.oldSelection = new Selection(this.board.getSelection());
        this.oldSelection.disconnect();
        this.board.selectionClear();
        this.board.selectionAdd(this.point);
        this.board.fireBatchedEvents();
        if (this.getMap() != null) {
            this.handler.repaint();
        }
        if (this.mapDisplay != null) {
            AddVertexAnimation animation = new AddVertexAnimation(this.point.getX(), this.point.getY());
            AnimationUpdater.runTimer((IMapDisplay)this.mapDisplay, (IAnimation)animation);
            this.handler.repaint();
        }
    }

    public String getName() {
        return String.valueOf(Messages.InsertVertexCommand_name1) + this.toAdd + Messages.InsertVertexCommand_name2 + this.index;
    }
}

