/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.ClosestEdge;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import org.eclipse.core.runtime.IProgressMonitor;

public class InsertOnNearestEdgeCommand
extends AbstractCommand
implements UndoableMapCommand {
    private final EditBlackboard board;
    private final EditGeom geom;
    private final Point toAdd;
    private List<ClosestEdge> edges;
    private EditToolHandler handler;

    public InsertOnNearestEdgeCommand(EditToolHandler handler2, EditBlackboard board, Point toAdd) {
        this(handler2, board, null, toAdd);
    }

    public InsertOnNearestEdgeCommand(EditToolHandler handler2, EditBlackboard board, EditGeom geom, Point toAdd) {
        this.board = board;
        this.geom = geom;
        this.toAdd = toAdd;
        this.handler = handler2;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.edges == null) {
            throw new RuntimeException("The command has not yet been run!!");
        }
        if (this.edges.size() == 0) {
            return;
        }
        for (ClosestEdge edge : this.edges) {
            this.board.removeCoordinate(edge.getIndexOfPrevious() + 1, edge.getAddedCoord(), edge.getPart());
        }
        if (this.getMap() != null) {
            this.handler.repaint();
        }
    }

    public void run(IProgressMonitor monitor) throws Exception {
        boolean polygonLayer;
        ILayer editLayer = this.handler.getEditLayer();
        Class type = editLayer.getSchema().getGeometryDescriptor().getType().getBinding();
        boolean bl = polygonLayer = Polygon.class.isAssignableFrom(type) || MultiPolygon.class.isAssignableFrom(type);
        if (this.geom == null) {
            this.edges = this.board.addToNearestEdge(this.toAdd.getX(), this.toAdd.getY(), polygonLayer);
        } else {
            this.edges = new ArrayList<ClosestEdge>();
            this.edges.add(this.board.addToNearestEdge(this.toAdd.getX(), this.toAdd.getY(), this.geom, polygonLayer));
        }
        if (this.getMap() != null) {
            this.handler.repaint();
        }
    }

    public String getName() {
        return String.valueOf(Messages.AddToNearestEdgeCommand_name) + this.toAdd;
    }
}

