/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import java.awt.Rectangle;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.Point;
import org.eclipse.core.runtime.IProgressMonitor;

public class DrawSnapAreaCommand
extends AbstractDrawCommand {
    private IProvider<Point> tracker;
    private Rectangle lastArea;

    public DrawSnapAreaCommand(IProvider<Point> tracker) {
        this.tracker = tracker;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.graphics.setColor(PreferenceUtil.instance().getFeedbackColor());
        int radius = PreferenceUtil.instance().getSnappingRadius();
        Point point = (Point)this.tracker.get(new Object[0]);
        int y = point.getY() - radius;
        int x = point.getX() - radius;
        this.graphics.drawOval(x, y, radius * 2, radius * 2);
        this.lastArea = new Rectangle(x - 4, y - 4, radius * 2 + 8, radius * 2 + 8);
    }

    public Rectangle getValidArea() {
        int radius = PreferenceUtil.instance().getSnappingRadius();
        Point point = (Point)this.tracker.get(new Object[0]);
        int y = point.getY() - radius;
        int x = point.getX() - radius;
        Rectangle rectangle = new Rectangle(x - 4, y - 4, radius * 2 + 8, radius * 2 + 8);
        if (this.lastArea != null) {
            return rectangle.union(this.lastArea);
        }
        return rectangle;
    }
}

