/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import java.awt.Rectangle;
import java.awt.Shape;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.tools.edit.MouseTracker;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;

public class DrawEndPointsCommand
extends AbstractDrawCommand
implements IDrawCommand {
    private IProvider<PrimitiveShape> provider;
    private MouseTracker tracker;
    boolean showMouseOver = true;

    public DrawEndPointsCommand(MouseTracker tracker, IProvider<PrimitiveShape> provider) {
        this.provider = provider;
        this.tracker = tracker;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        PrimitiveShape shape = (PrimitiveShape)this.provider.get(new Object[0]);
        if (shape == null || shape.getNumPoints() == 0) {
            return;
        }
        Point start = shape.getPoint(0);
        Point end = shape.getPoint(shape.getNumPoints() - 1);
        int radius = PreferenceUtil.instance().getVertexRadius();
        if (start == null || end == null) {
            return;
        }
        if (this.showMouseOver && this.tracker.getCurrentPoint() != null) {
            EditUtils.MinFinder finder = new EditUtils.MinFinder(this.tracker.getCurrentPoint());
            this.graphics.setColor(PreferenceUtil.instance().getDrawVertexFillColor());
            if (start != null && end != null && finder.dist(start) < (double)radius) {
                this.graphics.fill((Shape)new Rectangle(start.getX() - radius, start.getY() - radius, radius * 2, radius * 2));
                this.graphics.fill((Shape)new Rectangle(end.getX() - radius, end.getY() - radius, radius * 2, radius * 2));
            }
            if (start != null && end != null && finder.dist(end) < (double)radius) {
                this.graphics.fill((Shape)new Rectangle(start.getX() - radius, start.getY() - radius, radius * 2, radius * 2));
                this.graphics.fill((Shape)new Rectangle(end.getX() - radius, end.getY() - radius, radius * 2, radius * 2));
            }
        }
        this.graphics.setColor(PreferenceUtil.instance().getDrawVertexLineColor());
        this.graphics.draw((Shape)new Rectangle(start.getX() - radius, start.getY() - radius, radius * 2, radius * 2));
        this.graphics.draw((Shape)new Rectangle(end.getX() - radius, end.getY() - radius, radius * 2, radius * 2));
    }

    public IProvider<PrimitiveShape> getProvider() {
        return this.provider;
    }

    public void setProvider(IProvider<PrimitiveShape> provider) {
        this.provider = provider;
    }

    public boolean isShowMouseOver() {
        return this.showMouseOver;
    }

    public void setShowMouseOver(boolean showMouseOver) {
        this.showMouseOver = showMouseOver;
    }

    public Rectangle getValidArea() {
        if (this.provider == null) {
            return null;
        }
        PrimitiveShape obj = (PrimitiveShape)this.provider.get(new Object[0]);
        if (obj == null) {
            return null;
        }
        return ((PrimitiveShape)this.provider.get(new Object[0])).getBounds();
    }
}

