/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.refractions.udig.core.internal.GeometryBuilder;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.animation.GeometryOperationAnimation;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.IsBusyStateProvider;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.PrimitiveShapeIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.MathTransform;

public class DifferenceFeatureCommand
extends AbstractCommand
implements UndoableMapCommand {
    private EditToolHandler handler;
    private PrimitiveShape shape;
    private EditState state;
    private ILayer layer;
    private ArrayList<EditGeom> geoms;
    private EditState endState;
    private UndoableComposite writeCommand;
    private boolean addedEndVertex = false;

    public DifferenceFeatureCommand(EditToolHandler handler, EditState endState) {
        this.handler = handler;
        this.layer = handler.getEditLayer();
        this.endState = endState;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.DifferenceFeatureCommand_runTaskMessage, 10);
        monitor.worked(1);
        this.state = this.handler.getCurrentState();
        this.shape = this.handler.getCurrentShape();
        this.handler.setCurrentShape(null);
        ArrayList<UndoableMapCommand> commands = new ArrayList<UndoableMapCommand>();
        Point startPoint = this.shape.getPoint(0);
        if (!startPoint.equals(this.shape.getPoint(this.shape.getNumPoints() - 1))) {
            this.addedEndVertex = true;
            this.shape.getEditBlackboard().addPoint(startPoint.getX(), startPoint.getY(), this.shape);
        }
        GeometryOperationAnimation indicator = new GeometryOperationAnimation(PrimitiveShapeIterator.getPathIterator(this.shape).toShape(), new IsBusyStateProvider(this.handler));
        try {
            AnimationUpdater.runTimer((IMapDisplay)this.handler.getContext().getMapDisplay(), (IAnimation)indicator);
            this.handler.setCurrentState(EditState.BUSY);
            if (this.writeCommand == null) {
                EditBlackboard editBlackboard = this.handler.getEditBlackboard(this.layer);
                this.geoms = new ArrayList<EditGeom>(editBlackboard.getGeoms());
                this.geoms.remove(this.shape.getEditGeom());
                editBlackboard.clear();
                FeatureCollection<SimpleFeatureType, SimpleFeature> features = this.getFeatures(monitor);
                if (features == null) {
                    return;
                }
                try {
                    ArrayList<Geometry> geoms = new ArrayList<Geometry>();
                    geoms.add(this.createReferenceGeom());
                    SimpleFeature first = DifferenceFeatureCommand.runDifferenceOp((FeatureIterator<SimpleFeature>)features.features(), geoms);
                    if (first == null) {
                        return;
                    }
                    this.createAddFeatureCommands(commands, geoms, first);
                }
                finally {
                    monitor.worked(2);
                }
                this.writeCommand = new UndoableComposite(commands);
            }
            this.writeCommand.setMap((IMap)this.getMap());
            this.handler.setCurrentState(EditState.COMMITTING);
            this.writeCommand.execute((IProgressMonitor)new SubProgressMonitor(monitor, 5));
        }
        finally {
            indicator.setValid(false);
            this.handler.setCurrentState(this.endState);
            monitor.done();
        }
    }

    private void createAddFeatureCommands(List<UndoableMapCommand> commands, List<Geometry> geoms, SimpleFeature first) throws IllegalAttributeException {
        SimpleFeatureType featureType = first.getFeatureType();
        if (geoms.size() > 1 && !featureType.getGeometryDescriptor().getType().getBinding().isAssignableFrom(MultiPolygon.class) || !featureType.getGeometryDescriptor().getType().getBinding().isAssignableFrom(MultiPolygon.class)) {
            for (Geometry geom : geoms) {
                SimpleFeature newFeature = SimpleFeatureBuilder.copy((SimpleFeature)first);
                newFeature.setDefaultGeometry((Object)geom);
                commands.add(this.handler.getContext().getEditFactory().createAddFeatureCommand(newFeature, this.layer));
            }
        } else {
            SimpleFeature newFeature = SimpleFeatureBuilder.copy((SimpleFeature)first);
            GeometryFactory factory = new GeometryFactory();
            newFeature.setDefaultGeometry((Object)factory.createMultiPolygon(geoms.toArray(new Polygon[geoms.size()])));
            commands.add(this.handler.getContext().getEditFactory().createAddFeatureCommand(newFeature, this.layer));
        }
    }

    static Geometry combineIntoOneGeometry(Collection<Geometry> geometryCollection) {
        GeometryFactory factory = new GeometryFactory();
        Geometry combined = factory.buildGeometry(geometryCollection);
        return combined.union();
    }

    public static SimpleFeature runDifferenceOp(FeatureIterator<SimpleFeature> iter, List<Geometry> geoms) {
        Geometry createdGeometry;
        Geometry differenceGeometry = createdGeometry = DifferenceFeatureCommand.combineIntoOneGeometry(geoms);
        SimpleFeature first = null;
        try {
            HashSet<Geometry> featureGeoms = new HashSet<Geometry>();
            while (iter.hasNext()) {
                SimpleFeature f = (SimpleFeature)iter.next();
                if (first == null) {
                    first = f;
                }
                Geometry featureGeometry = (Geometry)f.getDefaultGeometry();
                featureGeoms.add(featureGeometry);
            }
            Geometry existingGeometry = DifferenceFeatureCommand.combineIntoOneGeometry(featureGeoms);
            if (existingGeometry != null) {
                differenceGeometry = createdGeometry.difference(existingGeometry);
            }
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
        geoms.clear();
        int i = 0;
        while (i < differenceGeometry.getNumGeometries()) {
            geoms.add(differenceGeometry.getGeometryN(i));
            ++i;
        }
        return first;
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(IProgressMonitor monitor) throws IOException, NoninvertibleTransformException, IllegalFilterException {
        String srs;
        ReferencedEnvelope layerBounds;
        FeatureSource source = (FeatureSource)this.layer.getResource(FeatureSource.class, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        SimpleFeatureType schema = this.layer.getSchema();
        Rectangle bounds = this.shape.getBounds();
        double[] toTransform = new double[]{bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()};
        this.handler.getContext().worldToScreenTransform().inverseTransform(toTransform, 0, toTransform, 0, 2);
        ReferencedEnvelope transformedBounds = new ReferencedEnvelope(toTransform[0], toTransform[2], toTransform[1], toTransform[3], this.handler.getContext().getCRS());
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        try {
            MathTransform transform = this.layer.mapToLayerTransform();
            layerBounds = new ReferencedEnvelope(JTS.transform((Envelope)transformedBounds, (MathTransform)transform), this.layer.getCRS());
        }
        catch (Exception exception) {
            layerBounds = transformedBounds;
        }
        String geomAttributeName = this.layer.getSchema().getGeometryDescriptor().getLocalName();
        try {
            srs = CRS.lookupIdentifier((IdentifiedObject)layerBounds.getCoordinateReferenceSystem(), (boolean)false);
        }
        catch (FactoryException e) {
            ProjectPlugin.getPlugin().log((Object)e);
            return null;
        }
        BBOX filter = filterFactory.bbox(geomAttributeName, layerBounds.getMinX(), layerBounds.getMinY(), layerBounds.getMaxX(), layerBounds.getMaxY(), srs);
        DefaultQuery query = new DefaultQuery(schema.getName().getLocalPart(), (Filter)filter);
        return source.getFeatures((Query)query);
    }

    private Geometry createReferenceGeom() {
        LinearRing ring = (LinearRing)GeometryBuilder.create().safeCreateGeometry(LinearRing.class, this.shape.coordArray());
        GeometryFactory fac = new GeometryFactory();
        return fac.createPolygon(ring, new LinearRing[0]);
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        GeometryOperationAnimation indicator = new GeometryOperationAnimation(PrimitiveShapeIterator.getPathIterator(this.shape).toShape(), new IsBusyStateProvider(this.handler));
        try {
            try {
                monitor.beginTask(Messages.DifferenceFeatureCommand_undoTaskMessage, 10);
                monitor.worked(1);
                AnimationUpdater.runTimer((IMapDisplay)this.handler.getContext().getMapDisplay(), (IAnimation)indicator);
                this.handler.setCurrentState(EditState.BUSY);
                SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 5);
                this.writeCommand.rollback((IProgressMonitor)submonitor);
                submonitor.done();
                EditBlackboard bb = this.handler.getEditBlackboard(this.layer);
                bb.clear();
                for (EditGeom geom : this.geoms) {
                    this.addGeom(bb, geom);
                }
                PrimitiveShape shell = this.addGeom(bb, this.shape.getEditGeom()).getShell();
                this.handler.setCurrentShape(shell);
                if (this.addedEndVertex) {
                    bb.removeCoordinate(this.shape.getNumCoords() - 1, this.shape.getCoord(this.shape.getNumCoords() - 1), shell);
                }
                this.handler.setCurrentState(this.state);
            }
            catch (Exception e) {
                this.handler.setCurrentState(EditState.NONE);
                throw e;
            }
        }
        finally {
            indicator.setValid(false);
            monitor.done();
        }
    }

    private EditGeom addGeom(EditBlackboard bb, EditGeom geom) {
        EditGeom newGeom = bb.newGeom(geom.getFeatureIDRef().get(), geom.getShapeType());
        newGeom.setChanged(geom.isChanged());
        for (PrimitiveShape shape : geom) {
            PrimitiveShape newShape = newGeom.getShell();
            if (shape != geom.getShell()) {
                newShape = newGeom.newHole();
            }
            Coordinate[] coords = shape.coordArray();
            int i = 0;
            while (i < coords.length) {
                bb.addCoordinate(coords[i], newShape);
                ++i;
            }
        }
        return newGeom;
    }

    public String getName() {
        return Messages.DifferenceFeatureCommand_name;
    }
}

