/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.core.Pair;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public class DeselectEditGeomCommand
extends AbstractCommand
implements UndoableMapCommand {
    private EditToolHandler handler;
    private List<EditGeom> geoms;
    private List<EditGeom> removed;
    private EditGeom currentGeom;
    private PrimitiveShape currentShape;
    private EditState currentState;
    private boolean removedAll;
    private UndoableMapCommand nullEditFeatureCommand;
    private ILayer layer;

    public DeselectEditGeomCommand(EditToolHandler handler, List<EditGeom> geoms) {
        this.handler = handler;
        this.geoms = geoms;
        this.layer = handler.getEditLayer();
    }

    private EditGeom setCurrentGeom(EditGeom newCurrentGeom, PrimitiveShape destination, PrimitiveShape shape) {
        if (this.currentGeom != null && newCurrentGeom != null && shape == this.currentShape) {
            this.handler.setCurrentShape(destination);
            return null;
        }
        return newCurrentGeom;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.RemoveEditGeomCommand_runTaskMessage, 20);
        this.removeGeomsFromBlackboard();
        if (this.removed.contains(this.handler.getCurrentGeom())) {
            this.deselectCurrentEditFeature(monitor);
        }
        Envelope env = new Envelope();
        HashSet<String> fids = new HashSet<String>();
        for (EditGeom geom : this.removed) {
            if (env.isNull()) {
                env.init(geom.getShell().getEnvelope());
            } else {
                env.expandToInclude(geom.getShell().getEnvelope());
            }
            fids.add(geom.getFeatureIDRef().get());
        }
        EditUtils.instance.refreshLayer(this.layer, fids, env, true, false);
        monitor.done();
    }

    private Pair<PrimitiveShape, SimpleFeature> newSelection(IProgressMonitor monitor) throws IOException {
        EditBlackboard editBlackboard = this.handler.getEditBlackboard(this.layer);
        if (!editBlackboard.isEmpty()) {
            EditGeom newSelection = editBlackboard.getGeoms().get(0);
            FilterFactory factory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            Id id = factory.id(Collections.singleton(factory.featureId(newSelection.getFeatureIDRef().get())));
            FeatureSource source = (FeatureSource)this.layer.getResource(FeatureSource.class, monitor);
            FeatureCollection features = source.getFeatures((Filter)id);
            FeatureIterator iter = features.features();
            try {
                if (iter.hasNext()) {
                    Pair pair = new Pair((Object)newSelection.getShell(), (Object)((SimpleFeature)iter.next()));
                    return pair;
                }
            }
            finally {
                iter.close();
            }
        }
        return new Pair(null, null);
    }

    private void deselectCurrentEditFeature(IProgressMonitor monitor) throws Exception {
        this.currentGeom = this.handler.getCurrentGeom();
        this.currentShape = this.handler.getCurrentShape();
        this.currentState = this.handler.getCurrentState();
        Pair<PrimitiveShape, SimpleFeature> newSelection = this.newSelection(monitor);
        this.handler.setCurrentShape((PrimitiveShape)newSelection.getLeft());
        if (newSelection.getLeft() == null) {
            this.handler.setCurrentState(EditState.NONE);
        }
        this.nullEditFeatureCommand = this.handler.getContext().getEditFactory().createSetEditFeatureCommand((SimpleFeature)newSelection.getRight(), this.layer);
        this.nullEditFeatureCommand.setMap((IMap)this.getMap());
        this.nullEditFeatureCommand.run((IProgressMonitor)new SubProgressMonitor(monitor, 10));
    }

    private void removeGeomsFromBlackboard() {
        if (this.geoms.containsAll(this.handler.getEditBlackboard(this.layer).getGeoms())) {
            this.removedAll = true;
            this.removed = this.handler.getEditBlackboard(this.layer).getGeoms();
            this.handler.getEditBlackboard(this.layer).clear();
        } else {
            this.removed = this.handler.getEditBlackboard(this.layer).removeGeometries(this.geoms);
        }
    }

    public String getName() {
        return Messages.RemoveEditGeomCommand_commandName;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.RemoveEditGeomCommand_rollbackTaskMessage, 20);
        if (this.currentState != null) {
            this.handler.setCurrentState(this.currentState);
        }
        if (this.nullEditFeatureCommand != null) {
            this.nullEditFeatureCommand.rollback((IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        EditBlackboard bb = this.handler.getEditBlackboard(this.layer);
        EditGeom newCurrentGeom = null;
        List<EditGeom> empty = bb.getGeoms();
        for (EditGeom original : this.removed) {
            EditGeom inBlackboard = bb.newGeom(original.getFeatureIDRef().get(), original.getShapeType());
            inBlackboard.setChanged(original.isChanged());
            if (original == this.currentGeom) {
                newCurrentGeom = inBlackboard;
            }
            PrimitiveShape destination = inBlackboard.getShell();
            newCurrentGeom = this.setCurrentGeom(newCurrentGeom, destination, original.getShell());
            Iterator<Coordinate> iter = original.getShell().coordIterator();
            while (iter.hasNext()) {
                bb.addCoordinate(iter.next(), destination);
            }
            for (PrimitiveShape shape : original.getHoles()) {
                destination = inBlackboard.newHole();
                newCurrentGeom = this.setCurrentGeom(newCurrentGeom, destination, shape);
                Iterator<Coordinate> iter2 = shape.coordIterator();
                while (iter2.hasNext()) {
                    bb.addCoordinate(iter2.next(), destination);
                }
            }
        }
        if (this.removedAll) {
            bb.removeGeometries(empty);
        }
    }
}

