/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;
import org.opengis.filter.Filter;

public class DefaultCancelEditingCommand
extends AbstractCommand
implements UndoableMapCommand {
    private EditToolHandler handler;
    private PrimitiveShape currentShape;
    private EditState currentState;
    private List<EditGeom> geoms;
    private Filter oldFilter;

    public DefaultCancelEditingCommand(EditToolHandler handler) {
        this.handler = handler;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        Layer editLayer = (Layer)this.handler.getEditLayer();
        if (this.currentShape != null) {
            this.currentShape = this.handler.getCurrentShape();
            this.currentState = this.handler.getCurrentState();
            this.geoms = this.handler.getEditBlackboard((ILayer)editLayer).getGeoms();
        }
        this.handler.setCurrentShape(null);
        this.handler.setCurrentState(EditState.NONE);
        this.oldFilter = editLayer.getFilter();
        editLayer.setFilter((Filter)Filter.EXCLUDE);
        EditUtils.instance.cancelHideSelection((ILayer)editLayer);
        EditBlackboard editBlackboard = this.handler.getEditBlackboard((ILayer)editLayer);
        editBlackboard.startBatchingEvents();
        editBlackboard.clear();
        editBlackboard.fireBatchedEvents();
        this.handler.repaint();
    }

    public String getName() {
        return Messages.DefaultCancelEditingCommand_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        Layer editLayer = (Layer)this.handler.getEditLayer();
        editLayer.setFilter(this.oldFilter);
        EditBlackboard editBlackboard = this.handler.getEditBlackboard((ILayer)editLayer);
        editBlackboard.startBatchingEvents();
        for (EditGeom geom : this.geoms) {
            this.copyFeature(editBlackboard, geom);
        }
        this.handler.setCurrentState(this.currentState);
        editBlackboard.fireBatchedEvents();
        this.handler.repaint();
    }

    private void copyFeature(EditBlackboard editBlackboard, EditGeom geom) {
        EditGeom newGeom = editBlackboard.newGeom(geom.getFeatureIDRef().get(), geom.getShapeType());
        for (PrimitiveShape shape : geom) {
            PrimitiveShape newShape = shape == geom.getShell() ? newGeom.getShell() : newGeom.newHole();
            if (shape == this.currentShape) {
                this.handler.setCurrentShape(newShape);
            }
            int i = 0;
            while (i < shape.getNumCoords()) {
                editBlackboard.addCoordinate(shape.getCoord(i), newShape);
                ++i;
            }
            newGeom.setChanged(geom.isChanged());
        }
    }
}

