/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import java.util.List;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateAndSelectHoleCommand
extends AbstractCommand
implements UndoableMapCommand {
    private EditToolHandler handler;
    private PrimitiveShape hole;
    private PrimitiveShape oldShape;
    private IBlockingProvider<PrimitiveShape> newShape;

    public CreateAndSelectHoleCommand(EditToolHandler handler) {
        this.handler = handler;
        this.newShape = new EditUtils.EditToolHandlerShapeProvider(handler);
    }

    public CreateAndSelectHoleCommand(IBlockingProvider<PrimitiveShape> shape) {
        this.newShape = shape;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        PrimitiveShape primitiveShape = (PrimitiveShape)this.newShape.get(monitor, new Object[0]);
        List<PrimitiveShape> holes = primitiveShape.getEditGeom().getHoles();
        for (PrimitiveShape shape : holes) {
            if (shape.getNumPoints() != 0) continue;
            this.hole = shape;
            break;
        }
        if (this.hole == null) {
            this.hole = primitiveShape.getEditGeom().newHole();
        }
        if (this.handler != null) {
            this.oldShape = this.handler.getCurrentShape();
            this.handler.setCurrentShape(this.hole);
        }
    }

    public String getName() {
        return Messages.CreateAndSelectHoleCommand_name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.handler != null) {
            this.handler.setCurrentShape(this.oldShape);
        }
        ((PrimitiveShape)this.newShape.get(monitor, new Object[0])).getEditGeom().getHoles().remove(this.hole);
    }

    public IBlockingProvider<PrimitiveShape> getHoleProvider() {
        return new ShapeProvider();
    }

    class ShapeProvider
    implements IBlockingProvider<PrimitiveShape> {
        ShapeProvider() {
        }

        public PrimitiveShape get(IProgressMonitor monitor, Object ... params) {
            return CreateAndSelectHoleCommand.this.hole;
        }
    }
}

