/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.commands;

import com.vividsolutions.jts.geom.Coordinate;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.animation.AddVertexAnimation;
import net.refractions.udig.tools.edit.animation.DeleteVertexAnimation;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddVertexCommand
extends AbstractCommand
implements UndoableMapCommand {
    private Coordinate toAdd = null;
    private boolean useSnapping;
    private Point point;
    private Coordinate addedCoord;
    private final EditBlackboard board;
    private IBlockingProvider<PrimitiveShape> shapeProvider;
    private EditToolHandler handler;
    private int index;
    private boolean showAnimation = true;

    public AddVertexCommand(EditToolHandler handler2, EditBlackboard editBlackboard, Point point) {
        this(handler2, editBlackboard, new EditUtils.EditToolHandlerShapeProvider(handler2), point, true);
    }

    public AddVertexCommand(EditToolHandler handler2, EditBlackboard bb, IBlockingProvider<PrimitiveShape> provider, Point point, boolean useSnapping) {
        this.handler = handler2;
        this.board = bb;
        this.shapeProvider = provider;
        this.point = point;
        this.useSnapping = useSnapping;
    }

    private Coordinate toCoordinate(Point point, boolean useSnapping) {
        Coordinate toCoord = this.board.toCoord(point);
        if (useSnapping) {
            Coordinate newCoord = EditUtils.instance.getClosestSnapPoint(this.handler, this.board, point, false, PreferenceUtil.instance().getSnapBehaviour(), this.handler.getCurrentState());
            if (newCoord != null) {
                this.point = this.board.toPoint(newCoord);
                return newCoord;
            }
            return toCoord;
        }
        return toCoord;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.addedCoord == null) {
            return;
        }
        if (this.handler.getContext().getMapDisplay() != null && this.showAnimation) {
            DeleteVertexAnimation animation = new DeleteVertexAnimation(this.point);
            AnimationUpdater.runTimer((IMapDisplay)this.handler.getContext().getMapDisplay(), (IAnimation)animation);
        }
        this.board.removeCoordinate(this.index, this.addedCoord, (PrimitiveShape)this.shapeProvider.get(monitor, new Object[0]));
        this.addedCoord = null;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        if (this.toAdd == null) {
            this.toAdd = this.toCoordinate(this.point, this.useSnapping);
        }
        PrimitiveShape shape = (PrimitiveShape)this.shapeProvider.get(monitor, new Object[0]);
        boolean collapseVertices = this.board.isCollapseVertices();
        try {
            this.board.setCollapseVertices(false);
            this.board.addCoordinate(this.toAdd, shape);
            this.addedCoord = this.toAdd;
            this.index = shape.getNumPoints() - 1;
        }
        finally {
            this.board.setCollapseVertices(collapseVertices);
        }
        if (this.handler.getContext().getMapDisplay() != null && this.showAnimation) {
            AddVertexAnimation animation = new AddVertexAnimation(this.point.getX(), this.point.getY());
            AnimationUpdater.runTimer((IMapDisplay)this.handler.getContext().getMapDisplay(), (IAnimation)animation);
        }
    }

    public String getName() {
        return String.valueOf(Messages.AddVertexCommand_name) + this.toAdd;
    }

    public Point getPointToAdd() {
        return this.point;
    }

    public boolean isShowAnimation() {
        return this.showAnimation;
    }

    public void setShowAnimation(boolean showAnimation) {
        this.showAnimation = showAnimation;
    }
}

