/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import java.util.ArrayList;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;

public class StartExtendLineBehaviour
implements EventBehaviour {
    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean button1Released;
        boolean legalEventType = eventType == EventType.RELEASED;
        boolean legalState = handler.getCurrentState() == EditState.MODIFYING || handler.getCurrentState() == EditState.NONE;
        boolean shapeAndGeomNotNull = handler.getCurrentShape() != null;
        boolean bl = button1Released = e.button == 8;
        if (!legalState || !legalEventType || !shapeAndGeomNotNull || !button1Released || e.buttonsDown() || e.modifiersDown()) {
            return false;
        }
        PrimitiveShape currentShape = handler.getCurrentShape();
        Point point = currentShape.getEditBlackboard().overVertex(Point.valueOf(e.x, e.y), PreferenceUtil.instance().getVertexRadius());
        return currentShape.getPoint(0).equals(point) || currentShape.getPoint(currentShape.getNumPoints() - 1).equals(point);
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        EditBlackboard editBlackboard = handler.getCurrentShape().getEditBlackboard();
        Point point = editBlackboard.overVertex(Point.valueOf(e.x, e.y), PreferenceUtil.instance().getVertexRadius());
        if (point.equals(handler.getCurrentShape().getPoint(0))) {
            ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>();
            commands.add(new ReversePointsInShapeCommand(handler, handler.getCurrentShape()));
            commands.add(new SetEditStateCommand(handler, EditState.CREATING));
            return new UndoableComposite(commands);
        }
        return new SetEditStateCommand(handler, EditState.CREATING);
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }

    private static class ReversePointsInShapeCommand
    extends AbstractCommand
    implements UndoableMapCommand {
        PrimitiveShape shape;

        ReversePointsInShapeCommand(EditToolHandler handler, PrimitiveShape shape) {
            this.shape = shape;
        }

        public void run(IProgressMonitor monitor) throws Exception {
            EditUtils.instance.reverseOrder(this.shape);
        }

        public String getName() {
            return "";
        }

        public void rollback(IProgressMonitor monitor) throws Exception {
            this.run(monitor);
        }
    }
}

