/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.commands.DeselectEditGeomCommand;
import net.refractions.udig.tools.edit.commands.DeselectionStrategy;
import net.refractions.udig.tools.edit.commands.SelectFeaturesAtPointCommand;
import net.refractions.udig.tools.edit.commands.SelectionParameter;
import net.refractions.udig.tools.edit.commands.SelectionStrategy;
import net.refractions.udig.tools.edit.commands.SetCurrentGeomCommand;
import net.refractions.udig.tools.edit.commands.SetEditFeatureCommand;
import net.refractions.udig.tools.edit.commands.selection.SelectFeatureStrategy;
import net.refractions.udig.tools.edit.commands.selection.WriteModificationsStartEditingStrategy;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.ClosestEdge;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.PrimitiveShapeIterator;
import net.refractions.udig.tools.edit.support.ShapeType;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;

public class SelectFeatureBehaviour
implements EventBehaviour {
    private final Set<Class<? extends Geometry>> acceptableClasses = new HashSet<Class<? extends Geometry>>();
    private boolean treatUnknownGeomsAsPolygon;
    private Class<? extends Filter> filterType;
    private boolean permitClear;
    private boolean onlyAdd;
    public final List<SelectionStrategy> selectionStrategies = new LinkedList<SelectionStrategy>();
    public final List<DeselectionStrategy> deselectionStrategies = new LinkedList<DeselectionStrategy>();

    public SelectFeatureBehaviour(Class<? extends Geometry>[] acceptableClasses, Class<? extends Filter> class2) {
        this.setAcceptableClasses(acceptableClasses);
        this.treatUnknownGeomsAsPolygon = false;
        Class<? extends Geometry>[] classArray = acceptableClasses;
        int n = acceptableClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Geometry> class1 = classArray[n2];
            if (class1.isAssignableFrom(Polygon.class) || class1.isAssignableFrom(MultiPolygon.class)) {
                this.treatUnknownGeomsAsPolygon = true;
                break;
            }
            ++n2;
        }
        this.filterType = class2;
        this.onlyAdd = false;
        this.permitClear = true;
        this.initDefaultStrategies(null);
    }

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean noPressedButtons;
        boolean legalState = handler.getCurrentState() == EditState.NONE || handler.getCurrentState() == EditState.MODIFYING;
        boolean releaseButtonState = eventType == EventType.RELEASED;
        boolean twoModifiersDown = e.isShiftDown() && e.isModifierDown(MapMouseEvent.MOD1_DOWN_MASK);
        boolean singleModifierDown = !twoModifiersDown;
        boolean altUp = !e.isAltDown();
        boolean legalButton = e.button == 8;
        boolean bl = noPressedButtons = e.buttons == 0;
        if (!(legalState && releaseButtonState && altUp && singleModifierDown && legalButton && noPressedButtons)) {
            return false;
        }
        if (e.isModifierDown(MapMouseEvent.MOD1_DOWN_MASK)) {
            return true;
        }
        if (handler.getCurrentGeom() == null) {
            return true;
        }
        if (!handler.getCurrentShape().contains(Point.valueOf(e.x, e.y), this.treatUnknownGeomsAsPolygon)) {
            return true;
        }
        return this.countOnBlackboard(handler, e) > 1;
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (!this.isValid(handler, e, eventType)) {
            throw new IllegalArgumentException("Behaviour is not valid for the current state");
        }
        EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
        List<EditGeom> intersectingGeoms = EditUtils.instance.getIntersectingGeom(editBlackboard, Point.valueOf(e.x, e.y), this.treatUnknownGeomsAsPolygon);
        if (e.isModifierDown(MapMouseEvent.MOD1_DOWN_MASK) && !intersectingGeoms.isEmpty()) {
            return new DeselectEditGeomCommand(handler, intersectingGeoms);
        }
        if (e.isShiftDown() && !intersectingGeoms.isEmpty()) {
            return null;
        }
        PrimitiveShape newShape = this.findOnBlackboard(handler, e);
        if (newShape != null && newShape != handler.getCurrentShape()) {
            ArrayList<AbstractCommand> commands = new ArrayList<AbstractCommand>();
            commands.add(new SetCurrentGeomCommand(handler, newShape));
            commands.add(new SetEditFeatureCommand(handler, Point.valueOf(e.x, e.y), newShape));
            UndoableComposite undoableComposite = new UndoableComposite(commands);
            return undoableComposite;
        }
        SelectionParameter selectionParameter = new SelectionParameter(handler, e, this.getAcceptableClasses(), this.filterType, this.permitClear, this.onlyAdd);
        selectionParameter.selectionStrategies.addAll(this.selectionStrategies);
        selectionParameter.deselectionStrategies.addAll(this.deselectionStrategies);
        SelectFeaturesAtPointCommand selectGeometryCommand = new SelectFeaturesAtPointCommand(selectionParameter);
        return selectGeometryCommand;
    }

    private PrimitiveShape findOnBlackboard(EditToolHandler handler, MapMouseEvent e) {
        boolean cycleGeom = false;
        boolean selectedFound = false;
        PrimitiveShape firstMatch = null;
        if (handler.getCurrentShape() != null && handler.getCurrentShape().contains(e.x, e.y) && this.countOnBlackboard(handler, e) > 1) {
            cycleGeom = true;
        }
        ILayer editLayer = handler.getEditLayer();
        List<EditGeom> geoms = handler.getEditBlackboard(editLayer).getGeoms();
        for (EditGeom geom : geoms) {
            PrimitiveShapeIterator iter = PrimitiveShapeIterator.getPathIterator(geom.getShell());
            if (iter.toShape().contains(e.x, e.y)) {
                if (cycleGeom) {
                    if (selectedFound) {
                        return geom.getShell();
                    }
                    if (geom == handler.getCurrentGeom()) {
                        selectedFound = true;
                    }
                    if (firstMatch == null) {
                        firstMatch = geom.getShell();
                    }
                } else {
                    return geom.getShell();
                }
            }
            if (cycleGeom) continue;
            SimpleFeatureType featureType = editLayer.getSchema();
            GeometryDescriptor defaultGeometryType = featureType.getGeometryDescriptor();
            Class type = defaultGeometryType.getType().getBinding();
            boolean polygonLayer = Polygon.class.isAssignableFrom(type) || MultiPolygon.class.isAssignableFrom(type);
            ClosestEdge edge = geom.getShell().getClosestEdge(Point.valueOf(e.x, e.y), polygonLayer);
            if (edge == null || !(edge.getDistanceToEdge() <= (double)PreferenceUtil.instance().getVertexRadius())) continue;
            return geom.getShell();
        }
        if (cycleGeom) {
            return firstMatch;
        }
        return null;
    }

    private int countOnBlackboard(EditToolHandler handler, MapMouseEvent e) {
        List<EditGeom> geoms = handler.getEditBlackboard(handler.getEditLayer()).getGeoms();
        int count = 0;
        for (EditGeom geom : geoms) {
            PrimitiveShapeIterator iter = PrimitiveShapeIterator.getPathIterator(geom.getShell());
            if (!iter.toShape().contains(e.x, e.y)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }

    public Class<? extends Geometry>[] getAcceptableClasses() {
        Class[] array = new Class[this.acceptableClasses.size()];
        return this.acceptableClasses.toArray(array);
    }

    public void setAcceptableClasses(Class<? extends Geometry>[] acceptableClasses) {
        this.acceptableClasses.clear();
        this.acceptableClasses.addAll(Arrays.asList(acceptableClasses));
    }

    public Class<? extends Filter> getFilterType() {
        return this.filterType;
    }

    public void setFilterType(Class<? extends Filter> filterType) {
        this.filterType = filterType;
    }

    public boolean isOnlyAdd() {
        return this.onlyAdd;
    }

    public void setOnlyAdd(boolean onlyAdd) {
        this.onlyAdd = onlyAdd;
    }

    public boolean isPermitClear() {
        return this.permitClear;
    }

    public void setPermitClear(boolean permitClear) {
        this.permitClear = permitClear;
    }

    public boolean isTreatUnknownGeomsAsPolygon() {
        return this.treatUnknownGeomsAsPolygon;
    }

    public void setTreatUnknownGeomsAsPolygon(boolean treatUnknownGeomsAsPolygon) {
        this.treatUnknownGeomsAsPolygon = treatUnknownGeomsAsPolygon;
    }

    public void addDeselectionStrategy(DeselectionStrategy strategy) {
        this.deselectionStrategies.add(strategy);
    }

    public void addSelectionStrategy(SelectionStrategy strategy) {
        this.selectionStrategies.add(strategy);
    }

    public void initDefaultStrategies(ShapeType typeToCreate) {
        this.selectionStrategies.add(new SelectFeatureStrategy());
        this.deselectionStrategies.add(new WriteModificationsStartEditingStrategy(typeToCreate));
    }
}

