/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.commands.InsertOnNearestEdgeCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.ClosestEdge;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.Point;

public class InsertVertexOnEdgeBehaviour
implements EventBehaviour {
    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean legalState;
        boolean legalEventType = eventType == EventType.RELEASED;
        boolean shapeAndGeomNotNull = handler.getCurrentShape() != null;
        boolean button1Released = e.button == 8;
        boolean bl = legalState = handler.getCurrentState() == EditState.NONE || handler.getCurrentState() == EditState.MODIFYING;
        return legalState && legalEventType && shapeAndGeomNotNull && button1Released && !e.buttonsDown() && !e.modifiersDown() && !this.overShapeVertex(handler, e) && this.isOverEdge(handler, e);
    }

    private boolean isOverEdge(EditToolHandler handler, MapMouseEvent e) {
        ILayer selectedLayer = handler.getEditLayer();
        Class type = selectedLayer.getSchema().getGeometryDescriptor().getType().getBinding();
        boolean polygonLayer = Polygon.class.isAssignableFrom(type) || MultiPolygon.class.isAssignableFrom(type);
        ClosestEdge edge = handler.getCurrentGeom().getClosestEdge(Point.valueOf(e.x, e.y), polygonLayer);
        if (edge == null) {
            return false;
        }
        return edge.getDistanceToEdge() <= (double)PreferenceUtil.instance().getVertexRadius();
    }

    private boolean overShapeVertex(EditToolHandler handler, MapMouseEvent e) {
        Point vertexOver = handler.getEditBlackboard(handler.getEditLayer()).overVertex(Point.valueOf(e.x, e.y), PreferenceUtil.instance().getVertexRadius());
        return handler.getCurrentShape().hasVertex(vertexOver);
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (!this.isValid(handler, e, eventType)) {
            throw new IllegalStateException("Cannot insert a vertext here");
        }
        ILayer editLayer = handler.getEditLayer();
        EditBlackboard editBlackboard = handler.getEditBlackboard(editLayer);
        Point toInsert = Point.valueOf(e.x, e.y);
        return new InsertOnNearestEdgeCommand(handler, editBlackboard, toInsert);
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }
}

