/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.ClosestEdge;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.PlatformUI;

public class CursorControlBehaviour
implements EventBehaviour {
    private IProvider<String> defaultMessage;
    private IProvider<Cursor> overVertexCursor;
    private IProvider<Cursor> overEdgeCursor;
    private IProvider<String> overEdgeMessage;
    private IProvider<String> overVertexMessage;

    public CursorControlBehaviour(EditToolHandler handler, IProvider<String> defaultMessage, IProvider<Cursor> overVertexCursor, IProvider<String> overVertexMessage, IProvider<Cursor> overEdgeCursor, IProvider<String> overEdgeMessage) {
        this.defaultMessage = defaultMessage;
        this.overVertexCursor = overVertexCursor == null ? new DefaultCursorProvider(handler) : overVertexCursor;
        this.overEdgeCursor = overEdgeCursor == null ? new DefaultCursorProvider(handler) : overEdgeCursor;
        this.overVertexMessage = overVertexMessage == null ? new NullStringProvider() : overVertexMessage;
        this.overEdgeMessage = overEdgeMessage == null ? new NullStringProvider() : overEdgeMessage;
    }

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean isMove;
        boolean isHover = eventType == EventType.HOVERED;
        boolean bl = isMove = eventType == EventType.MOVED;
        return isHover || isMove;
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (this.overVertex(handler, e)) {
            this.setCursorAndMessage((Cursor)this.overVertexCursor.get(new Object[0]), (String)this.overVertexMessage.get(new Object[0]), handler);
        } else if (eventType == EventType.HOVERED && this.onEdge(handler, e)) {
            this.setCursorAndMessage((Cursor)this.overEdgeCursor.get(new Object[0]), (String)this.overEdgeMessage.get(new Object[0]), handler);
        } else {
            this.setCursorAndMessage(handler.editCursor, (String)this.defaultMessage.get(new Object[0]), handler);
        }
        return null;
    }

    private boolean onEdge(EditToolHandler handler, MapMouseEvent e) {
        Point point = Point.valueOf(e.x, e.y);
        EditGeom geom = handler.getCurrentGeom();
        if (geom == null) {
            return false;
        }
        ILayer selectedLayer = handler.getEditLayer();
        Class type = selectedLayer.getSchema().getGeometryDescriptor().getType().getBinding();
        boolean polygonLayer = Polygon.class.isAssignableFrom(type) || MultiPolygon.class.isAssignableFrom(type);
        ClosestEdge closestEdge = geom.getClosestEdge(point, polygonLayer);
        return closestEdge != null && closestEdge.getDistanceToEdge() < (double)PreferenceUtil.instance().getVertexRadius();
    }

    private boolean overVertex(EditToolHandler handler, MapMouseEvent e) {
        if (handler.getCurrentShape() == null) {
            return false;
        }
        int radius = PreferenceUtil.instance().getVertexRadius();
        Point point = Point.valueOf(e.x, e.y);
        return handler.getCurrentGeom().overVertex(point, radius) != null;
    }

    private void setCursorAndMessage(final Cursor cursor, final String string, final EditToolHandler handler) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().isClosing()) {
                    return;
                }
                IActionBars2 bars = handler.getContext().getActionBars();
                if (bars != null) {
                    bars.getStatusLineManager().setErrorMessage(null);
                    bars.getStatusLineManager().setMessage(string);
                }
                handler.getContext().getViewportPane().setCursor(cursor);
            }
        };
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }

    public static class DefaultCursorProvider
    implements IProvider<Cursor> {
        private EditToolHandler handler;

        public DefaultCursorProvider(EditToolHandler handler) {
            this.handler = handler;
        }

        public Cursor get(Object ... params) {
            return this.handler.editCursor;
        }
    }

    public static class NullStringProvider
    implements IProvider<String> {
        public String get(Object ... params) {
            return null;
        }
    }

    public static class SystemCursorProvider
    implements IProvider<Cursor> {
        private int id;

        public SystemCursorProvider(int swtCursorID) {
            this.id = swtCursorID;
        }

        public Cursor get(Object ... params) {
            final Cursor[] cursor = new Cursor[1];
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    cursor[0] = Display.getDefault().getSystemCursor(SystemCursorProvider.this.id);
                }
            });
            return cursor[0];
        }
    }
}

