/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.internal.commands.draw.DrawShapeCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.LockingBehaviour;
import net.refractions.udig.tools.edit.MouseTracker;
import net.refractions.udig.tools.edit.commands.CreateEditGeomCommand;
import net.refractions.udig.tools.edit.commands.DeselectEditGeomCommand;
import net.refractions.udig.tools.edit.commands.SetCurrentGeomCommand;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.ShapeType;

public class CreateShapeBehaviour
implements EventBehaviour,
LockingBehaviour {
    private ShapeFactory factory;
    private GeneralPath path;
    private DrawShapeCommand drawCommand;

    public CreateShapeBehaviour(ShapeFactory factory) {
        this.factory = factory;
    }

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean legalState;
        if (handler.isLocked() && handler.isLockOwner(this) && eventType == EventType.DRAGGED) {
            return true;
        }
        boolean bl = legalState = handler.getCurrentState() == EditState.NONE;
        return !e.modifiersDown() && legalState && e.buttons == 8 && eventType == EventType.DRAGGED;
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        int translationY;
        int translationX;
        if (this.path == null) {
            this.path = this.factory.create(1, 1);
            handler.getBehaviours().add(new Creator());
            handler.lock(this);
        }
        MouseTracker tracker = handler.getMouseTracker();
        if (this.factory.useMiddleAsOrigin()) {
            translationX = tracker.getDragStarted().getX();
            translationY = tracker.getDragStarted().getY();
        } else {
            translationX = Math.min(tracker.getDragStarted().getX(), e.x);
            translationY = Math.min(tracker.getDragStarted().getY(), e.y);
        }
        int scaleX = Math.abs(tracker.getDragStarted().getX() - e.x);
        int scaleY = Math.abs(tracker.getDragStarted().getY() - e.y);
        if (e.isShiftDown()) {
            if (scaleX > scaleY) {
                scaleY = scaleX;
            } else {
                scaleX = scaleY;
            }
        }
        AffineTransform transform = AffineTransform.getTranslateInstance(translationX, translationY);
        transform.scale(scaleX, scaleY);
        Shape transformedShape = this.path.createTransformedShape(transform);
        if (this.drawCommand == null) {
            this.drawCommand = new DrawShapeCommand();
            this.drawCommand.setPaint(PreferenceUtil.instance().getDrawGeomsLine());
            handler.getContext().sendSyncCommand((Command)this.drawCommand);
        }
        this.drawCommand.setShape(transformedShape);
        handler.repaint();
        return null;
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }

    @Override
    public Object getKey(EditToolHandler handler) {
        return this;
    }

    private class Creator
    implements LockingBehaviour {
        private Creator() {
        }

        @Override
        public Object getKey(EditToolHandler handler) {
            return CreateShapeBehaviour.this;
        }

        @Override
        public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
            return handler.isLockOwner(this) && eventType == EventType.RELEASED && e.button == 8;
        }

        @Override
        public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
            try {
                PathIterator iter = CreateShapeBehaviour.this.drawCommand.getShape().getPathIterator(AffineTransform.getTranslateInstance(0.0, 0.0), 1.0);
                UndoableComposite commands = new UndoableComposite();
                commands.getCommands().add(handler.getContext().getEditFactory().createNullEditFeatureCommand());
                EditBlackboard bb = handler.getEditBlackboard(handler.getEditLayer());
                commands.getCommands().add(new DeselectEditGeomCommand(handler, bb.getGeoms()));
                ShapeType shapeType = this.determineLayerType(handler);
                CreateEditGeomCommand createEditGeomCommand = new CreateEditGeomCommand(bb, "newShape", shapeType);
                commands.getCommands().add(createEditGeomCommand);
                commands.getCommands().add(EditUtils.instance.appendPathToShape(iter, shapeType, handler, bb, createEditGeomCommand.getShapeProvider()));
                commands.getCommands().add(new SetCurrentGeomCommand(handler, createEditGeomCommand.getShapeProvider()));
                commands.getCommands().add(handler.getCommand(handler.getAcceptBehaviours()));
                commands.getFinalizerCommands().add(new SetEditStateCommand(handler, EditState.NONE));
                UndoableComposite undoableComposite = commands;
                return undoableComposite;
            }
            finally {
                CreateShapeBehaviour.this.drawCommand.setValid(false);
                CreateShapeBehaviour.this.drawCommand = null;
                CreateShapeBehaviour.this.path = null;
                handler.unlock(this);
            }
        }

        private ShapeType determineLayerType(EditToolHandler handler) {
            Class type = handler.getEditLayer().getSchema().getGeometryDescriptor().getType().getBinding();
            if (LineString.class.isAssignableFrom(type) || LinearRing.class.isAssignableFrom(type) || MultiLineString.class.isAssignableFrom(type)) {
                return ShapeType.LINE;
            }
            return ShapeType.POLYGON;
        }

        @Override
        public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
            EditPlugin.log("", error);
        }
    }

    public static abstract class ShapeFactory {
        protected boolean middleAsOrigin = false;

        public abstract GeneralPath create(int var1, int var2);

        public boolean useMiddleAsOrigin() {
            return this.middleAsOrigin;
        }

        public void setMiddleAsOrigin(boolean middleAsOrigin) {
            this.middleAsOrigin = middleAsOrigin;
        }
    }
}

