/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.UndoRedoCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.animation.MessageBubble;
import net.refractions.udig.tools.edit.behaviour.IEditValidator;
import net.refractions.udig.tools.edit.commands.AddVertexCommand;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class AddVertexWhileCreatingBehaviour
implements EventBehaviour {
    private IEditValidator validator = IEditValidator.TRUE;

    public void setEditValidator(IEditValidator validator) {
        this.validator = validator;
    }

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean legalState = handler.getCurrentState() == EditState.CREATING;
        boolean legalEventType = eventType == EventType.RELEASED || eventType == EventType.DOUBLE_CLICK;
        boolean shapeAndGeomNotNull = handler.getCurrentShape() != null;
        boolean button1Released = e.button == 8;
        Point point = Point.valueOf(e.x, e.y);
        return legalState && legalEventType && shapeAndGeomNotNull && button1Released && !e.buttonsDown() && !e.modifiersDown() && this.isNotDuplicated(handler, point);
    }

    protected boolean isNotDuplicated(EditToolHandler handler, Point point) {
        int vertexRadius;
        PrimitiveShape currentShape = handler.getCurrentShape();
        if (currentShape.getNumPoints() == 0) {
            return true;
        }
        ILayer editLayer = handler.getEditLayer();
        EditBlackboard editBlackboard = handler.getEditBlackboard(editLayer);
        Point vertexOver = editBlackboard.overVertex(point, vertexRadius = PreferenceUtil.instance().getVertexRadius());
        if (vertexOver == null) {
            return true;
        }
        if (currentShape.getNumPoints() > 2 && vertexOver.equals(currentShape.getPoint(0))) {
            return true;
        }
        return !currentShape.hasVertex(vertexOver);
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        String reasonForFaliure = this.validator.isValid(handler, e, eventType);
        if (reasonForFaliure != null) {
            AnimationUpdater.runTimer((IMapDisplay)handler.getContext().getMapDisplay(), (IAnimation)new MessageBubble(e.x, e.y, String.valueOf(Messages.AddVertexWhileCreatingBehaviour_illegal) + "\n" + reasonForFaliure, PreferenceUtil.instance().getMessageDisplayDelay()));
            return null;
        }
        Point valueOf = Point.valueOf(e.x, e.y);
        EditBlackboard editBlackboard = handler.getEditBlackboard(handler.getEditLayer());
        Point destination = handler.getEditBlackboard(handler.getEditLayer()).overVertex(valueOf, PreferenceUtil.instance().getVertexRadius());
        if (destination == null) {
            destination = valueOf;
        }
        AddVertexCommand addVertexCommand = new AddVertexCommand(handler, editBlackboard, destination);
        try {
            addVertexCommand.setMap(handler.getContext().getMap());
            addVertexCommand.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e1) {
            throw (RuntimeException)new RuntimeException().initCause(e1);
        }
        return new UndoRedoCommand((UndoableMapCommand)addVertexCommand);
    }
}

