/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.behaviour;

import java.util.ArrayList;
import net.refractions.udig.project.command.UndoRedoCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.BehaviourCommand;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import net.refractions.udig.tools.edit.support.Point;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class AcceptWhenOverFirstVertexBehaviour
implements EventBehaviour {
    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        boolean button1Released;
        boolean legalState = handler.getCurrentState() == EditState.CREATING;
        boolean legalEventType = eventType == EventType.RELEASED && eventType != EventType.DOUBLE_CLICK;
        boolean shapeAndGeomNotNull = handler.getCurrentShape() != null;
        boolean bl = button1Released = e.button == 8;
        return legalState && legalEventType && shapeAndGeomNotNull && button1Released && !e.buttonsDown() && !e.modifiersDown() && this.overFirstVertex(handler, e);
    }

    private boolean overFirstVertex(EditToolHandler handler, MapMouseEvent e) {
        Point vertexOver = handler.getEditBlackboard(handler.getEditLayer()).overVertex(Point.valueOf(e.x, e.y), PreferenceUtil.instance().getVertexRadius());
        return handler.getCurrentShape().getNumPoints() > 0 && handler.getCurrentShape().getPoint(0).equals(vertexOver);
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        if (!this.isValid(handler, e, eventType)) {
            throw new IllegalArgumentException("Current state is not legal");
        }
        ArrayList<BehaviourCommand> commands = new ArrayList<BehaviourCommand>();
        commands.add(handler.getCommand(handler.getAcceptBehaviours()));
        UndoableComposite undoableComposite = new UndoableComposite(commands);
        undoableComposite.setMap(handler.getContext().getMap());
        try {
            undoableComposite.execute((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e1) {
            throw (RuntimeException)new RuntimeException().initCause(e1);
        }
        return new UndoRedoCommand((UndoableMapCommand)undoableComposite);
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("", error);
    }
}

