/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.animation;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseListener;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseMotionListener;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseWheelEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseWheelListener;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import org.eclipse.core.runtime.IProgressMonitor;

public class MessageBubble
extends AbstractDrawCommand
implements IAnimation {
    private int x;
    private int y;
    private String[] message;
    private short delay;
    private Rectangle validArea;
    private int verticalBorder = 5;
    private int horizontalBorder = 5;
    private int verticalCornerArc = 15;
    private int horizontalCornerArc = 15;
    private Color bubbleColor = new Color(0, 0, 0, 167);
    private Color textColor = new Color(200, 200, 200, 167);
    private Font myFont = null;
    private MapMouseListener mouseListener = new MapMouseListener(){

        public void mouseDoubleClicked(MapMouseEvent event) {
            MessageBubble.this.disable((ViewportPane)event.source, this);
        }

        public void mouseEntered(MapMouseEvent event) {
            MessageBubble.this.disable((ViewportPane)event.source, this);
        }

        public void mouseExited(MapMouseEvent event) {
            MessageBubble.this.disable((ViewportPane)event.source, this);
        }

        public void mousePressed(MapMouseEvent event) {
            MessageBubble.this.disable((ViewportPane)event.source, this);
        }

        public void mouseReleased(MapMouseEvent event) {
            MessageBubble.this.disable((ViewportPane)event.source, this);
        }
    };
    private MapMouseWheelListener wheelListener = new MapMouseWheelListener(){

        public void mouseWheelMoved(MapMouseWheelEvent e) {
            MessageBubble.this.disable(MessageBubble.this.display, this);
        }
    };

    public MessageBubble(int x, int y, String message, short delay) {
        this.x = x;
        this.y = y;
        this.processMessage(message);
        this.delay = delay;
    }

    private void processMessage(String message) {
        String[] stringArray = this.message = message.split("[\n\r]");
        int n = this.message.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String string = part.replaceAll("\t", "    ");
            ++n2;
        }
    }

    public short getFrameInterval() {
        return this.delay;
    }

    public boolean hasNext() {
        return false;
    }

    public void nextFrame() {
    }

    public void run(IProgressMonitor monitor) throws Exception {
        if (this.myFont != null) {
            this.graphics.setFont(this.myFont);
        }
        this.display.addMouseListener(this.mouseListener);
        this.display.addMouseWheelListener(this.wheelListener);
        Rectangle messageBounds = new Rectangle(0, 0);
        String[] stringArray = this.message;
        int n = this.message.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            Rectangle2D size = this.graphics.getStringBounds(part);
            messageBounds = new Rectangle((int)Math.max(size.getWidth(), ((RectangularShape)messageBounds).getWidth()), (int)(size.getHeight() + ((RectangularShape)messageBounds).getHeight()));
            ++n2;
        }
        if ((double)this.x + ((RectangularShape)messageBounds).getWidth() > (double)(this.display.getWidth() + this.horizontalBorder)) {
            this.x = (int)((double)(this.display.getWidth() - this.horizontalBorder) - ((RectangularShape)messageBounds).getWidth());
        }
        if ((double)this.y + ((RectangularShape)messageBounds).getHeight() > (double)(this.display.getHeight() + this.verticalBorder)) {
            this.y = (int)((double)(this.display.getHeight() - this.verticalBorder) - ((RectangularShape)messageBounds).getHeight());
        }
        this.validArea = new Rectangle(this.x, this.y, (int)((RectangularShape)messageBounds).getWidth() + this.horizontalBorder, (int)((RectangularShape)messageBounds).getHeight() + this.verticalBorder);
        this.graphics.setColor(this.bubbleColor);
        this.graphics.fillRoundRect(this.x, this.y, (int)((RectangularShape)messageBounds).getWidth() + this.horizontalBorder, (int)((RectangularShape)messageBounds).getHeight() + this.verticalBorder, this.horizontalCornerArc, this.verticalCornerArc);
        this.graphics.setColor(this.textColor);
        int height = this.graphics.getFontHeight();
        int i = 0;
        int verticalOffset = this.verticalBorder / 2;
        int horizontalOffset = this.horizontalBorder / 2;
        String[] stringArray2 = this.message;
        int n3 = this.message.length;
        int n4 = 0;
        while (n4 < n3) {
            String part = stringArray2[n4];
            this.graphics.drawString(part, this.x + horizontalOffset, this.y + verticalOffset + height * i, -1, -1);
            ++i;
            ++n4;
        }
    }

    public Rectangle getValidArea() {
        return this.validArea;
    }

    public void setHorizontalBorder(int horizontalBorder) {
        this.horizontalBorder = horizontalBorder;
    }

    public void setVerticalBorder(int verticalBorder) {
        this.verticalBorder = verticalBorder;
    }

    public void setHorizontalCornerArc(int horizontalCornerArc) {
        this.horizontalCornerArc = horizontalCornerArc;
    }

    public void setVerticalCornerArc(int verticalCornerArc) {
        this.verticalCornerArc = verticalCornerArc;
    }

    public Color getBubbleColor() {
        return this.bubbleColor;
    }

    public void setBubbleColor(Color bubbleColor) {
        this.bubbleColor = bubbleColor;
    }

    public void setFont(Font font) {
        this.myFont = font;
    }

    public Font getFont() {
        return this.myFont;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setValid(boolean valid) {
        super.setValid(valid);
        this.display.removeMouseListener(this.mouseListener);
        this.display.removeMouseWheelListener(this.wheelListener);
    }

    void disable(ViewportPane pane, Object listener) {
        if (!this.isValid((IMapDisplay)pane)) {
            if (listener instanceof MapMouseMotionListener) {
                pane.removeMouseMotionListener((MapMouseMotionListener)listener);
            } else if (listener instanceof MapMouseListener) {
                pane.removeMouseListener((MapMouseListener)listener);
            } else if (listener instanceof MapMouseWheelListener) {
                pane.removeMouseWheelListener((MapMouseWheelListener)listener);
            }
            return;
        }
        this.setValid(false);
        Rectangle bounds = this.getValidArea();
        if (bounds == null) {
            pane.repaint();
        } else {
            pane.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    private boolean isValid(IMapDisplay source) {
        if (!this.isValid()) {
            return false;
        }
        return source == this.display;
    }
}

