/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.activator;

import net.refractions.udig.project.BlackboardEvent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IBlackboardListener;
import net.refractions.udig.tools.edit.AbstractEditTool;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;

public class EditStateListenerActivator
implements Activator {
    private IconManager iconManager;

    @Override
    public void activate(EditToolHandler handler) {
        this.iconManager = new IconManager(handler);
        handler.getContext().getMap().getBlackboard().addListener((IBlackboardListener)this.iconManager);
    }

    @Override
    public void deactivate(EditToolHandler handler) {
        handler.getContext().getMap().getBlackboard().removeListener((IBlackboardListener)this.iconManager);
        this.iconManager = null;
    }

    @Override
    public void handleActivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("", error);
    }

    @Override
    public void handleDeactivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("", error);
    }

    class IconManager
    implements IBlackboardListener {
        private EditToolHandler handler;

        IconManager(EditToolHandler handler2) {
            this.handler = handler2;
        }

        public void blackBoardChanged(BlackboardEvent event) {
            if (EditStateListenerActivator.this.iconManager == null) {
                event.getSource().removeListener((IBlackboardListener)this);
                return;
            }
            if (event.getKey() == "EDIT_TOOL_HANDLER_EDIT_STATE_KEY_33847562") {
                EditState oldState = (EditState)((Object)event.getOldValue());
                EditState newState = (EditState)((Object)event.getNewValue());
                if (newState == null) {
                    newState = EditState.NONE;
                }
                if (oldState == newState) {
                    return;
                }
                switch (newState) {
                    case NONE: 
                    case MODIFYING: 
                    case CREATING: {
                        AbstractEditTool tool = this.handler.getTool();
                        String defaultCursorId = (String)tool.getProperty("defaultCursorId");
                        this.handler.setCursor(defaultCursorId);
                        break;
                    }
                    case ILLEGAL: {
                        this.handler.setCursor("no");
                        break;
                    }
                    case MOVING: {
                        this.handler.setCursor("move");
                        break;
                    }
                    case BUSY: 
                    case COMMITTING: {
                        this.handler.setCursor("wait");
                    }
                }
            }
        }

        public void blackBoardCleared(IBlackboard source) {
        }
    }
}

