/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.activator;

import java.util.Iterator;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.ApplicationGISInternal;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.RemoveAllVerticesCommand;
import net.refractions.udig.tools.edit.commands.RemoveSelectedVerticesCommand;
import net.refractions.udig.tools.edit.commands.SetCurrentGeomCommand;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.Point;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;

public class DeleteGlobalActionSetterActivator
implements Activator {
    private IAction oldAction;
    private DeleteVertexHandler deleteVertexHandler;

    @Override
    public void activate(EditToolHandler handler) {
        IActionBars2 actionBars = handler.getContext().getActionBars();
        if (actionBars == null) {
            return;
        }
        MapEditorPart part = ApplicationGISInternal.getActiveEditor();
        if (part == null) {
            return;
        }
        this.oldAction = ApplicationGIS.getToolManager().getDELETEAction();
        IKeyBindingService keyBindingService = part.getSite().getKeyBindingService();
        if (this.oldAction != null) {
            keyBindingService.unregisterAction(this.oldAction);
        }
        this.deleteVertexHandler = new DeleteVertexHandler(handler);
        if (this.oldAction != null) {
            this.deleteVertexHandler.setImageDescriptor(this.oldAction.getImageDescriptor());
            this.deleteVertexHandler.setDisabledImageDescriptor(this.oldAction.getDisabledImageDescriptor());
        }
        ApplicationGIS.getToolManager().setDELETEAction((IAction)this.deleteVertexHandler, (IWorkbenchPart)part);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteVertexHandler);
        actionBars.updateActionBars();
        keyBindingService.registerAction((IAction)this.deleteVertexHandler);
    }

    @Override
    public void deactivate(EditToolHandler handler) {
        IActionBars2 actionBars = handler.getContext().getActionBars();
        if (actionBars == null || this.oldAction == null) {
            return;
        }
        MapEditorPart part = ApplicationGISInternal.getActiveEditor();
        if (part == null) {
            return;
        }
        IWorkbenchPartSite site = part.getSite();
        IKeyBindingService keyBindingService = site.getKeyBindingService();
        keyBindingService.unregisterAction((IAction)this.deleteVertexHandler);
        this.deleteVertexHandler = null;
        ApplicationGIS.getToolManager().setDELETEAction(this.oldAction, (IWorkbenchPart)part);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.oldAction);
        if (this.oldAction != null) {
            keyBindingService.registerAction(this.oldAction);
        }
        this.oldAction = null;
        actionBars.updateActionBars();
    }

    @Override
    public void handleActivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("", error);
    }

    @Override
    public void handleDeactivateError(EditToolHandler handler, Throwable error) {
        EditPlugin.log("", error);
    }

    static class DeleteVertexHandler
    extends Action {
        private EditToolHandler handler;

        DeleteVertexHandler(EditToolHandler handler) {
            this.handler = handler;
            this.setText(Messages.DeleteGlobalActionSetterActivator_title);
            this.setToolTipText(Messages.DeleteGlobalActionSetterActivator_tooltip);
        }

        public void runWithEvent(Event event) {
            EditGeom currentGeom = this.handler.getCurrentGeom();
            if (currentGeom == null) {
                return;
            }
            EditBlackboard editBlackboard = currentGeom.getEditBlackboard();
            if (editBlackboard.getSelection().isEmpty() || this.hasNoPoints()) {
                UndoableComposite composite = new UndoableComposite();
                composite.getCommands().add(new SetEditStateCommand(this.handler, EditState.BUSY));
                composite.getCommands().add(new RemoveAllVerticesCommand(this.handler));
                composite.getCommands().add(this.handler.getCommand(this.handler.getAcceptBehaviours()));
                composite.getCommands().add(new SetCurrentGeomCommand(this.handler, null));
                composite.getFinalizerCommands().add(new SetEditStateCommand(this.handler, EditState.MODIFYING));
                this.handler.getContext().sendASyncCommand((Command)composite);
            } else {
                UndoableComposite composite = new UndoableComposite();
                composite.getFinalizerCommands().add(new SetEditStateCommand(this.handler, EditState.MODIFYING));
                composite.getCommands().add(new SetEditStateCommand(this.handler, EditState.BUSY));
                RemoveSelectedVerticesCommand removeCommand = new RemoveSelectedVerticesCommand(this.handler);
                removeCommand.setRunAnimation(editBlackboard.getSelection().size() < 10);
                composite.getCommands().add(removeCommand);
                this.handler.getContext().sendASyncCommand((Command)composite);
            }
        }

        private boolean hasNoPoints() {
            Iterator<Point> iter = this.handler.getCurrentGeom().getShell().iterator();
            EditBlackboard editBlackboard = this.handler.getCurrentGeom().getEditBlackboard();
            while (iter.hasNext()) {
                if (editBlackboard.getSelection().contains(iter.next())) continue;
                return false;
            }
            return true;
        }
    }
}

