/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.LockingBehaviour;

public class MutualExclusiveEventBehavior
implements EventBehaviour,
LockingBehaviour {
    private List<EventBehaviour> behaviours = new ArrayList<EventBehaviour>();
    private EventBehaviour current;
    private static final Object NULL_KEY = new Object();

    public MutualExclusiveEventBehavior(List<EventBehaviour> modes) {
        this.behaviours = modes;
    }

    public MutualExclusiveEventBehavior(EventBehaviour behaviour) {
        this.behaviours.add(behaviour);
    }

    @Override
    public boolean isValid(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        for (EventBehaviour mode : this.behaviours) {
            if (!mode.isValid(handler, e, eventType)) continue;
            this.current = mode;
            return true;
        }
        return false;
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler, MapMouseEvent e, EventType eventType) {
        return this.current.getCommand(handler, e, eventType);
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("Very Strange I don't know how this happenned...", error);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[");
        for (EventBehaviour behaviour : this.behaviours) {
            buffer.append(behaviour.toString());
            buffer.append("||");
        }
        buffer.reverse();
        buffer.append("  ");
        buffer.reverse();
        buffer.append("]");
        return null;
    }

    public List<EventBehaviour> getBehaviours() {
        return this.behaviours;
    }

    @Override
    public Object getKey(EditToolHandler handler) {
        for (EventBehaviour behaviour : this.behaviours) {
            LockingBehaviour locker;
            if (!(behaviour instanceof LockingBehaviour) || !handler.isLockOwner(locker = (LockingBehaviour)behaviour)) continue;
            return locker.getKey(handler);
        }
        return NULL_KEY;
    }
}

