/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;

public class MutualExclusiveBehavior
implements Behaviour {
    private List<Behaviour> behaviours = new ArrayList<Behaviour>();

    public MutualExclusiveBehavior(List<Behaviour> modes) {
        this.behaviours = modes;
    }

    public MutualExclusiveBehavior(Behaviour behaviour) {
        this.behaviours.add(behaviour);
    }

    public MutualExclusiveBehavior() {
    }

    @Override
    public boolean isValid(EditToolHandler handler) {
        for (Behaviour mode : this.behaviours) {
            EditPlugin.trace("net.refractions.udig.tools.edit/behaviour", "  Validating mode: " + mode.getClass().getName(), null);
            if (!mode.isValid(handler)) continue;
            return true;
        }
        return false;
    }

    @Override
    public UndoableMapCommand getCommand(EditToolHandler handler) {
        ArrayList<Behaviour> behaviours = new ArrayList<Behaviour>(this.behaviours);
        for (Behaviour mode : behaviours) {
            if (!mode.isValid(handler)) continue;
            UndoableMapCommand c = null;
            try {
                c = mode.getCommand(handler);
                EditPlugin.trace("net.refractions.udig.tools.edit/behaviour", "  Running mode: " + mode.getClass().getName(), null);
                return c;
            }
            catch (Throwable error) {
                EditPlugin.trace("net.refractions.udig.tools.edit/behaviour", "Error running mode: " + mode.getClass().getName(), null);
                mode.handleError(handler, error, c);
            }
        }
        return null;
    }

    @Override
    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        EditPlugin.log("Very Strange I don't know how this happenned...", error);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[");
        for (Behaviour behaviour : this.behaviours) {
            buffer.append(behaviour.toString());
            buffer.append("||");
        }
        buffer.reverse();
        buffer.append("  ");
        buffer.reverse();
        buffer.append("]");
        return buffer.toString();
    }

    public List<Behaviour> getBehaviours() {
        return this.behaviours;
    }
}

