/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.PostDeterminedEffectCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.EventType;
import net.refractions.udig.tools.edit.LockingBehaviour;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class EventBehaviourCommand
extends AbstractCommand
implements PostDeterminedEffectCommand {
    private List<EventBehaviour> behaviours;
    private List<UndoableMapCommand> commandsRan = new LinkedList<UndoableMapCommand>();
    private EditToolHandler handler;
    private MapMouseEvent event;
    private EventType eventType;
    String name = Messages.EventBehaviourCommand_name;

    public EventBehaviourCommand(List<EventBehaviour> behaviours, EditToolHandler handler, MapMouseEvent event, EventType eventType) {
        this.behaviours = behaviours;
        this.handler = handler;
        this.event = event;
        this.eventType = eventType;
    }

    public boolean execute(IProgressMonitor monitor) throws Exception {
        if (this.commandsRan.isEmpty()) {
            monitor.beginTask(this.getName(), this.commandsRan.size() * 12);
            monitor.worked(2);
            for (EventBehaviour behaviour : this.behaviours) {
                if (!this.canUnlock(behaviour) || !behaviour.isValid(this.handler, this.event, this.eventType)) continue;
                UndoableMapCommand c = null;
                try {
                    c = behaviour.getCommand(this.handler, this.event, this.eventType);
                    if (c == null) continue;
                    SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 10);
                    c.setMap((IMap)this.getMap());
                    if (c instanceof PostDeterminedEffectCommand) {
                        PostDeterminedEffectCommand command = (PostDeterminedEffectCommand)c;
                        if (command.execute((IProgressMonitor)submonitor)) {
                            this.commandsRan.add((UndoableMapCommand)command);
                        }
                    } else {
                        c.run((IProgressMonitor)submonitor);
                        this.commandsRan.add(c);
                    }
                    submonitor.done();
                }
                catch (Exception e) {
                    behaviour.handleError(this.handler, e, c);
                }
            }
        } else {
            monitor.beginTask(this.getName(), this.commandsRan.size() * 12);
            monitor.worked(2);
            for (UndoableMapCommand command : this.commandsRan) {
                command.setMap((IMap)this.getMap());
                SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 10);
                if (command instanceof PostDeterminedEffectCommand) {
                    ((PostDeterminedEffectCommand)command).execute((IProgressMonitor)submonitor);
                } else {
                    command.run((IProgressMonitor)submonitor);
                }
                submonitor.done();
            }
        }
        monitor.done();
        return !this.commandsRan.isEmpty();
    }

    private boolean canUnlock(EventBehaviour behaviour) {
        if (!this.handler.isLocked()) {
            return true;
        }
        if (behaviour instanceof LockingBehaviour) {
            LockingBehaviour locker = (LockingBehaviour)behaviour;
            EditPlugin.trace("net.refractions.udig.tools.edit/handler/lock", "Can unlock: " + (this.handler.behaviourLock == locker.getKey(this.handler)), null);
            return this.handler.behaviourLock == locker.getKey(this.handler);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(this.getName(), this.commandsRan.size() * 12);
        monitor.worked(2);
        for (UndoableMapCommand command : this.commandsRan) {
            command.setMap((IMap)this.getMap());
            SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 10);
            command.rollback((IProgressMonitor)submonitor);
            submonitor.done();
        }
    }

    public void run(IProgressMonitor monitor) throws Exception {
        throw new UnsupportedOperationException("PostDeterminedEffectCommands do not use the run method");
    }
}

