/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import java.util.List;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.tool.Tool;
import net.refractions.udig.tools.edit.AbstractEditTool;
import net.refractions.udig.tools.edit.EditBlackboardUtil;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.opengis.filter.Filter;

class EditManagerListener
implements IEditManagerListener {
    private static final String EDITING_EDIT_MANAGER_LISTENER = "EDITING_EDIT_MANAGER_LISTENER_234234567";
    static volatile IEditManager committing = null;
    IEditManager editManager;
    private EditToolHandler handler;

    static synchronized void enableEditManagerListener(EditToolHandler handler) {
        IEditManager editManager = handler.getContext().getEditManager();
        if (EditManagerListener.getRegisteredListener(editManager) == null) {
            EditManagerListener editManagerListener = new EditManagerListener(editManager, handler);
            editManager.addListener((IEditManagerListener)editManagerListener);
            editManager.getMap().getBlackboard().put(EDITING_EDIT_MANAGER_LISTENER, (Object)editManagerListener);
        } else {
            EditManagerListener.getRegisteredListener((IEditManager)editManager).handler = handler;
        }
    }

    private static EditManagerListener getRegisteredListener(IEditManager editManager) {
        return (EditManagerListener)editManager.getMap().getBlackboard().get(EDITING_EDIT_MANAGER_LISTENER);
    }

    EditManagerListener(IEditManager em, EditToolHandler handler2) {
        this.editManager = em;
        this.handler = handler2;
    }

    public IEditManager getEditManager() {
        return this.editManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(EditManagerEvent event) {
        EditManagerListener editManagerListener = this;
        synchronized (editManagerListener) {
            if (EditManagerListener.getRegisteredListener(this.editManager) == null || EditManagerListener.getRegisteredListener(this.editManager) != this) {
                event.getSource().removeListener((IEditManagerListener)this);
                return;
            }
        }
        ILayer selectedLayer = event.getSource().getSelectedLayer();
        switch (event.getType()) {
            case -2: {
                Tool tool = ApplicationGIS.getToolManager().getActiveTool();
                if (!(tool instanceof AbstractEditTool)) break;
                AbstractEditTool aet = (AbstractEditTool)tool;
                PrimitiveShape shape = aet.getHandler().getCurrentShape();
                if (shape != null && shape.getEditGeom().isChanged()) {
                    aet.getContext().sendSyncCommand((Command)aet.getHandler().getCommand(aet.getHandler().getAcceptBehaviours()));
                }
                committing = event.getSource();
                break;
            }
            case -1: {
                committing = null;
                this.stopListening();
                this.resetEditState(selectedLayer);
                break;
            }
            case -3: {
                this.resetEditState(selectedLayer);
                committing = event.getSource();
                break;
            }
            case -4: {
                this.stopListening();
                committing = null;
                break;
            }
            case 5: {
                ILayer oldValue = (ILayer)event.getOldValue();
                ILayer newValue = (ILayer)event.getNewValue();
                Lock lock2 = this.handler.getLock();
                lock2.lock();
                try {
                    this.handler.getCurrentState();
                    if (this.handler.getCurrentState() != EditState.ILLEGAL) {
                        this.storeCurrentState(oldValue);
                        this.getPreviousStateFromLayer(newValue);
                        this.storeCurrentShape(oldValue);
                        this.setCurrentShape(newValue);
                    }
                }
                finally {
                    lock2.unlock();
                }
                if (!this.active()) {
                    return;
                }
                if (!ApplicationGIS.getOpenMaps().contains(newValue.getMap())) break;
                EditUtils.instance.cancelHideSelection(oldValue);
                EditUtils.instance.hideSelectedFeatures(this.handler, newValue);
                break;
            }
        }
    }

    private boolean active() {
        return ApplicationGIS.getToolManager().getActiveTool() instanceof AbstractEditTool;
    }

    private void setCurrentShape(ILayer layer) {
        PrimitiveShape shapeToRestoreToCurrent;
        if (layer == null) {
            shapeToRestoreToCurrent = null;
        } else {
            IBlackboard blackboard = layer.getBlackboard();
            shapeToRestoreToCurrent = (PrimitiveShape)blackboard.get("STORED_CURRENT_SHAPE");
            blackboard.put("STORED_CURRENT_SHAPE", null);
        }
        this.handler.setCurrentShape(shapeToRestoreToCurrent);
    }

    private void storeCurrentShape(ILayer layer) {
        if (layer != null) {
            PrimitiveShape currentShape = this.handler.getCurrentShape();
            layer.getBlackboard().put("STORED_CURRENT_SHAPE", (Object)currentShape);
        }
    }

    private void storeCurrentState(ILayer layer) {
        if (layer != null) {
            IBlackboard blackboard = layer.getBlackboard();
            blackboard.put("STORED_CURRENT_STATE", (Object)this.handler.getCurrentState());
            blackboard.put("STORED_CURRENT_STATE", null);
        }
    }

    private void getPreviousStateFromLayer(ILayer layer) {
        EditState stateToRestore;
        if (layer == null) {
            stateToRestore = EditState.ILLEGAL;
        } else {
            stateToRestore = (EditState)((Object)layer.getBlackboard().get("STORED_CURRENT_STATE"));
            if (stateToRestore == null) {
                stateToRestore = EditState.NONE;
            }
        }
        this.handler.setCurrentState(stateToRestore);
    }

    private synchronized void stopListening() {
        if (!this.active()) {
            this.editManager.removeListener((IEditManagerListener)this);
            this.editManager.getMap().getBlackboard().put(EDITING_EDIT_MANAGER_LISTENER, null);
        }
    }

    private void resetEditState(ILayer selectedLayer) {
        EditBlackboardUtil.resetBlackboards(this.editManager.getMap());
        this.editManager.getMap().getBlackboard().put("EDIT_TOOL_HANDLER_CURRENT_SHAPE_KEY_872839", null);
        this.editManager.getMap().getBlackboard().put("EDIT_TOOL_HANDLER_EDIT_STATE_KEY_33847562", (Object)EditState.NONE);
        ((EditManager)this.editManager).setEditFeature(null, null);
        EditUtils.instance.cancelHideSelection(selectedLayer);
        List mapLayers = this.editManager.getMap().getMapLayers();
        for (ILayer layer : mapLayers) {
            ((Layer)layer).setFilter((Filter)Filter.EXCLUDE);
        }
        EditUtils.instance.clearLayerStateShapeCache(mapLayers);
    }
}

