/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILayerListener;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.EditManager;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.impl.EditManagerImpl;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.render.displayAdapter.IMapDisplayListener;
import net.refractions.udig.project.render.displayAdapter.MapDisplayEvent;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.project.ui.tool.Tool;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.AbstractEditTool;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditManagerListener;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class EditBlackboardUtil {
    private static final MathTransform IDENTITY;
    private static volatile ViewportModelListener listener;
    public static final EditBlackboard EMPTY_BLACKBOARD;
    public static final String EDIT_BLACKBOARD_KEY = "EDIT_BLACKBOARD_KEY_839834";
    private static Lock blackboardLock;
    private static Map<ILayer, ILayerListener> layerListenerMap;
    private static Map<ILayer, Envelope> dirtyAreas;
    static volatile Dialog dialog;
    static IHandler clearEditBlackboardHandler;
    static ICommandListener clearEditBlackboardCommandListener;

    static {
        MathTransform tmp = null;
        try {
            tmp = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        catch (FactoryException factoryException) {}
        IDENTITY = tmp;
        EMPTY_BLACKBOARD = new EditBlackboard(0, 0, AffineTransform.getTranslateInstance(0.0, 0.0), IDENTITY);
        blackboardLock = new ReentrantLock();
        layerListenerMap = new HashMap<ILayer, ILayerListener>();
        dirtyAreas = new HashMap<ILayer, Envelope>();
    }

    public static EditBlackboard getEditBlackboard(IToolContext context, ILayer layer2) {
        EditBlackboard editBlackBoard;
        if (layer2 == null || !ApplicationGIS.getOpenMaps().contains(layer2.getMap())) {
            return EMPTY_BLACKBOARD;
        }
        ILayer layer = layer2;
        blackboardLock.lock();
        try {
            EditManager editManager = (EditManager)context.getEditManager();
            if (editManager.getEditLayer() != null && editManager.isEditLayerLocked()) {
                layer = context.getEditManager().getEditLayer();
            }
            if ((editBlackBoard = EditBlackboardUtil.getEditBlackBoardFromLayer(layer)) == null) {
                MathTransform layerToMapTransform;
                try {
                    layerToMapTransform = layer.layerToMapTransform();
                }
                catch (IOException e) {
                    EditPlugin.log("", e);
                    layerToMapTransform = IDENTITY;
                }
                final EditBlackboard bb = editBlackBoard = new EditBlackboard(context.getMapDisplay().getWidth(), context.getMapDisplay().getHeight(), context.worldToScreenTransform(), layerToMapTransform);
                context.getViewportPane().addPaneListener(new IMapDisplayListener(){

                    public void sizeChanged(MapDisplayEvent event) {
                        if (event.getOldSize() != null && event.getOldSize().width != event.getSize().width) {
                            bb.setWidth(event.getSize().width);
                        }
                        if (event.getOldSize() != null && event.getOldSize().height != event.getSize().height) {
                            bb.setHeight(event.getSize().height);
                        }
                    }
                });
                layer.getBlackboard().put(EDIT_BLACKBOARD_KEY, (Object)editBlackBoard);
            }
            EditBlackboardUtil.enableViewportListener((ViewportModel)context.getViewportModel());
        }
        finally {
            blackboardLock.unlock();
        }
        if (dirtyAreas.get(layer) != null) {
            EditBlackboardUtil.openDataChangedDialog(layer, dirtyAreas.get(layer));
        }
        editBlackBoard.setToScreenTransform(context.worldToScreenTransform());
        return editBlackBoard;
    }

    private static synchronized void enableLayerChangeEventListener(final ILayer layer, EditBlackboard editBlackboard) {
        ILayerListener listener = layerListenerMap.get(layer);
        if (listener == null) {
            listener = new ILayerListener(){

                public void refresh(LayerEvent event) {
                    if (event.getSource() != layer) {
                        layer.removeListener((ILayerListener)this);
                        return;
                    }
                    if (event.getType() != LayerEvent.EventType.EDIT_EVENT) {
                        return;
                    }
                    EditManager editManager = (EditManager)layer.getMap().getEditManager();
                    Layer editlayer = editManager.getSelectedLayer();
                    if (editManager.getEditLayer() != null && editManager.isEditLayerLocked()) {
                        editlayer = editManager.getEditLayer();
                    }
                    EditState currentEditState = (EditState)((Object)layer.getMap().getBlackboard().get("EDIT_TOOL_HANDLER_EDIT_STATE_KEY_33847562"));
                    if (editlayer == layer && (currentEditState == EditState.COMMITTING || EditManagerListener.committing == editManager)) {
                        return;
                    }
                    FeatureEvent editEvent = (FeatureEvent)event.getNewValue();
                    if (editEvent == null) {
                        return;
                    }
                    Envelope dirtyArea = (Envelope)dirtyAreas.get(editlayer);
                    if (dirtyArea == null) {
                        dirtyArea = editEvent.getBounds();
                    } else {
                        dirtyArea.expandToInclude((Envelope)editEvent.getBounds());
                    }
                    dirtyAreas.put(editlayer, dirtyArea);
                    if (editlayer == layer && layer.getMap() == ApplicationGIS.getActiveMap()) {
                        EditBlackboardUtil.openDataChangedDialog((ILayer)editlayer, dirtyArea);
                    }
                }
            };
            layerListenerMap.put(layer, listener);
        }
        layer.addListener(listener);
    }

    /*
     * Unable to fully structure code
     */
    public static void openDataChangedDialog(final ILayer layer, final Envelope dirtyArea) {
        block10: {
            d = Display.getCurrent();
            if (d == null) {
                d = Display.getDefault();
            }
            condition = EditBlackboardUtil.blackboardLock.newCondition();
            try {
                EditBlackboardUtil.blackboardLock.lock();
                if (EditBlackboardUtil.dialog == null) break block10;
                if (Display.getCurrent() == null) ** GOTO lbl18
lbl9:
                // 2 sources

                return;
lbl-1000:
                // 1 sources

                {
                    try {
                        condition.await(500L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    catch (InterruptedException v0) {
                        EditBlackboardUtil.blackboardLock.unlock();
                        return;
                    }
lbl18:
                    // 2 sources

                    ** while (EditBlackboardUtil.dialog != null)
                }
lbl19:
                // 1 sources

                ** continue;
            }
            finally {
                EditBlackboardUtil.blackboardLock.unlock();
            }
        }
        PlatformGIS.syncInDisplayThread((Display)d, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    blackboardLock.lock();
                    if (dirtyAreas.get(layer) == null) {
                        return;
                    }
                    dialog = new Dialog(Display.getCurrent().getActiveShell()){
                        private final int UPDATE = 1;
                        private final int CLEAR = 2;
                        private final int IGNORE = 3;
                        {
                            super($anonymous0);
                            this.UPDATE = 1;
                            this.CLEAR = 2;
                            this.IGNORE = 3;
                        }

                        public Control createDialogArea(Composite parent) {
                            Composite comp = new Composite(parent, 0);
                            comp.setLayout((Layout)new GridLayout(2, false));
                            Display display = Display.getCurrent();
                            Label label = new Label(comp, 0);
                            label.setBackground(display.getSystemColor(22));
                            label.setForeground(display.getSystemColor(21));
                            label.setImage(Dialog.getImage((String)"dialog_warning_image"));
                            label.setLayoutData((Object)new GridData(4, 0, true, false));
                            Text text = new Text(comp, 72);
                            text.setLayoutData((Object)new GridData(4, 4, true, true));
                            text.setBackground(display.getSystemColor(22));
                            text.setForeground(display.getSystemColor(21));
                            text.setText(Messages.EditBlackboardUtil_data_changed);
                            return comp;
                        }

                        public void createButtonsForButtonBar(Composite composite) {
                            this.createButton(composite, 1, Messages.EditBlackboardUtil_update, false);
                            this.createButton(composite, 2, Messages.EditBlackboardUtil_clear, true);
                            this.createButton(composite, 3, Messages.EditBlackboardUtil_ignore, false);
                        }

                        public void buttonPressed(int button) {
                            switch (button) {
                                case 1: {
                                    boolean ok = MessageDialog.openConfirm((Shell)this.getParentShell(), (String)Messages.EditBlackboardUtil_Update_Selection, (String)Messages.EditBlackboardUtil_update_selection_confirmation);
                                    if (!ok) break;
                                    try {
                                        ProgressMonitorDialog d = new ProgressMonitorDialog(this.getParentShell());
                                        blackboardLock.unlock();
                                        d.run(false, false, new IRunnableWithProgress(){

                                            public void run(IProgressMonitor monitor) {
                                                EditBlackboardUtil.updateFeatures(layer, monitor, dirtyArea);
                                            }
                                        });
                                        this.okPressed();
                                    }
                                    catch (Exception e) {
                                        EditPlugin.log("", e);
                                    }
                                    break;
                                }
                                case 2: {
                                    boolean ok = MessageDialog.openConfirm((Shell)this.getParentShell(), (String)Messages.EditBlackboardUtil_clear_selection, (String)Messages.EditBlackboardUtil_changes_will_be_lost);
                                    if (!ok) break;
                                    blackboardLock.unlock();
                                    EditBlackboardUtil.getEditBlackBoardFromLayer(layer).clear();
                                    layer.getMap().getBlackboard().put("EDIT_TOOL_HANDLER_CURRENT_SHAPE_KEY_872839", null);
                                    ((EditManager)layer.getMap().getEditManager()).setEditFeature(null, null);
                                    this.okPressed();
                                    break;
                                }
                                case 3: {
                                    boolean ok = MessageDialog.openConfirm((Shell)this.getParentShell(), (String)Messages.EditBlackboardUtil_ignore_change, (String)Messages.EditBlackboardUtil_changes_will_be_overwritten);
                                    if (!ok) break;
                                    this.okPressed();
                                    break;
                                }
                                default: {
                                    this.cancelPressed();
                                }
                            }
                        }

                        public void okPressed() {
                            dirtyAreas.remove(layer);
                            super.okPressed();
                        }
                    };
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                }
                finally {
                    blackboardLock.unlock();
                    dialog = null;
                }
            }
        });
    }

    public static void updateFeatures(ILayer layer, IProgressMonitor monitor, Envelope dirtyArea) {
        EditBlackboard bb = EditBlackboardUtil.getEditBlackBoardFromLayer(layer);
        List<EditGeom> geoms = bb.getGeoms();
        monitor.beginTask(Messages.EditBlackboardUtil_updating_selected_features, geoms.size());
        PrimitiveShape shape = (PrimitiveShape)layer.getMap().getBlackboard().get("EDIT_TOOL_HANDLER_CURRENT_SHAPE_KEY_872839");
        EditManager editManager = (EditManager)layer.getMap().getEditManager();
        FilterFactory factory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        for (EditGeom geom : geoms) {
            ids.add(factory.featureId(geom.getFeatureIDRef().get()));
        }
        Id fidFilter = factory.id(ids);
        And filter = factory.and((Filter)fidFilter, layer.createBBoxFilter(dirtyArea, (IProgressMonitor)new NullProgressMonitor()));
        try {
            FeatureSource fs = (FeatureSource)layer.getResource(FeatureSource.class, monitor);
            FeatureCollection results = fs.getFeatures((Filter)filter);
            FeatureIterator reader = results.features();
            try {
                int read = 0;
                boolean selectedFound = false;
                ArrayList<EditGeom> toRemove = new ArrayList<EditGeom>();
                while (reader.hasNext()) {
                    int count = geoms.size() - read;
                    monitor.setTaskName(MessageFormat.format(Messages.EditBlackboardUtil_count_remaining, count));
                    ++read;
                    SimpleFeature feature = (SimpleFeature)reader.next();
                    for (EditGeom geom : geoms) {
                        if (!feature.getID().equals(geom.getFeatureIDRef().get())) continue;
                        toRemove.add(geom);
                    }
                    Map<Geometry, EditGeom> mapping = bb.addGeometry((Geometry)feature.getDefaultGeometry(), feature.getID());
                    if (feature.getID().equals(shape.getEditGeom().getFeatureIDRef().get())) {
                        editManager.setEditFeature(feature, (Layer)layer);
                        layer.getMap().getBlackboard().put("EDIT_TOOL_HANDLER_CURRENT_SHAPE_KEY_872839", (Object)mapping.values().iterator().next().getShell());
                        selectedFound = true;
                    }
                    monitor.worked(1);
                }
                if (!selectedFound) {
                    layer.getMap().getBlackboard().put("EDIT_TOOL_HANDLER_CURRENT_SHAPE_KEY_872839", null);
                    editManager.setEditFeature(null, null);
                }
                bb.removeGeometries(toRemove);
            }
            finally {
                reader.close();
                monitor.done();
            }
        }
        catch (IOException e) {
            EditPlugin.log("", e);
        }
    }

    private static EditBlackboard getEditBlackBoardFromLayer(ILayer layer) {
        blackboardLock.lock();
        try {
            EditBlackboard editBlackboard = (EditBlackboard)layer.getBlackboard().get(EDIT_BLACKBOARD_KEY);
            return editBlackboard;
        }
        finally {
            blackboardLock.unlock();
        }
    }

    static synchronized void enableClearBlackboardCommand(IToolContext context) {
        if (clearEditBlackboardHandler == null) {
            clearEditBlackboardHandler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    Tool tool = ApplicationGIS.getToolManager().getActiveTool();
                    if (tool instanceof AbstractEditTool) {
                        EditToolHandler editToolHandler = ((AbstractEditTool)tool).getHandler();
                        List<Behaviour> behaviours = editToolHandler.getCancelBehaviours();
                        UndoableComposite compositeCommand = new UndoableComposite();
                        for (Behaviour behaviour : behaviours) {
                            UndoableMapCommand command;
                            if (!behaviour.isValid(editToolHandler) || (command = behaviour.getCommand(editToolHandler)) == null) continue;
                            compositeCommand.getCommands().add(command);
                        }
                        if (!compositeCommand.getCommands().isEmpty()) {
                            editToolHandler.getContext().sendASyncCommand((Command)compositeCommand);
                        }
                    }
                    return null;
                }
            };
        }
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        org.eclipse.core.commands.Command command = service.getCommand("net.refractions.udig.tool.edit.clearAction");
        command.setHandler(clearEditBlackboardHandler);
        if (clearEditBlackboardCommandListener == null) {
            clearEditBlackboardCommandListener = new ICommandListener(){

                public void commandChanged(CommandEvent commandEvent) {
                    if (commandEvent.isHandledChanged()) {
                        commandEvent.getCommand().removeCommandListener((ICommandListener)this);
                        clearEditBlackboardCommandListener = null;
                        IMap map = ApplicationGIS.getActiveMap();
                        EditBlackboardUtil.resetBlackboards(map);
                    }
                }
            };
            command.addCommandListener(clearEditBlackboardCommandListener);
        }
    }

    static synchronized void disableClearBlackboardCommand() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        org.eclipse.core.commands.Command command = service.getCommand("net.refractions.udig.tool.edit.clearAction");
        if (clearEditBlackboardCommandListener != null) {
            command.removeCommandListener(clearEditBlackboardCommandListener);
            clearEditBlackboardCommandListener = null;
        }
        command.setHandler(null);
    }

    public static void doneListening() {
        EditBlackboardUtil.disableViewportListener();
    }

    public static synchronized void disableLayerEvents() {
        Set<Map.Entry<ILayer, ILayerListener>> entries = layerListenerMap.entrySet();
        for (Map.Entry entry : entries) {
            ((ILayer)entry.getKey()).removeListener((ILayerListener)entry.getValue());
        }
        layerListenerMap.clear();
    }

    public static ILayer findEditLayer(IToolContext context) {
        ILayer layer2 = null;
        IMap map = context.getMap();
        Layer selectedLayer = ((EditManagerImpl)map.getEditManager()).getSelectedLayer();
        if (EditBlackboardUtil.isEditable((ILayer)selectedLayer)) {
            return selectedLayer;
        }
        if (EditBlackboardUtil.isEditable(map.getEditManager().getEditLayer())) {
            return map.getEditManager().getEditLayer();
        }
        for (ILayer layer2 : map.getMapLayers()) {
            if (EditBlackboardUtil.isEditable(layer2)) break;
        }
        return layer2;
    }

    private static boolean isEditable(ILayer layer) {
        return layer != null && layer.hasResource(FeatureStore.class) && layer.getInteraction(Interaction.EDIT) && layer.isVisible();
    }

    private static synchronized void enableViewportListener(ViewportModel model) {
        EditBlackboardUtil.disableViewportListener();
        listener = new ViewportModelListener(model);
        EditBlackboardUtil.listener.model.eAdapters().add((Object)listener);
    }

    private static synchronized void disableViewportListener() {
        if (listener != null) {
            EditBlackboardUtil.listener.model.eAdapters().remove((Object)listener);
        }
        listener = null;
    }

    public static void resetBlackboards(IMap map) {
        if (map != null) {
            blackboardLock.lock();
            try {
                List layers = map.getMapLayers();
                for (ILayer layer : layers) {
                    EditBlackboard blackboard = EditBlackboardUtil.getEditBlackBoardFromLayer(layer);
                    if (blackboard == null) continue;
                    blackboard.clear();
                    layer.getBlackboard().put(EDIT_BLACKBOARD_KEY, null);
                }
            }
            finally {
                blackboardLock.unlock();
            }
        }
    }

    static class ViewportModelListener
    extends AdapterImpl {
        ViewportModel model;
        private ILayer layer;

        ViewportModelListener(ViewportModel model) {
            this.model = model;
            this.layer = model.getMap().getEditManager().getSelectedLayer();
        }

        public void notifyChanged(Notification msg) {
            if (listener == null) {
                this.model.eAdapters().remove((Object)listener);
                listener = this;
                return;
            }
            switch (msg.getFeatureID(ViewportModel.class)) {
                case 1: {
                    EditBlackboard editBlackBoard = EditBlackboardUtil.getEditBlackBoardFromLayer(this.layer);
                    if (editBlackBoard == null) {
                        return;
                    }
                    editBlackBoard.setToScreenTransform(this.model.worldToScreenTransform());
                    break;
                }
                case 0: {
                    EditBlackboard editBlackBoard = EditBlackboardUtil.getEditBlackBoardFromLayer(this.layer);
                    if (editBlackBoard == null) {
                        return;
                    }
                    try {
                        editBlackBoard.setMapLayerTransform(this.layer.mapToLayerTransform());
                    }
                    catch (IOException e) {
                        EditPlugin.log("", e);
                    }
                    editBlackBoard.setToScreenTransform(this.model.worldToScreenTransform());
                }
            }
        }
    }
}

