/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.EnablementBehaviour;
import net.refractions.udig.tools.edit.MutualExclusiveBehavior;
import net.refractions.udig.tools.edit.activator.ClearCurrentSelectionActivator;
import net.refractions.udig.tools.edit.activator.DrawCurrentGeomVerticesActivator;
import net.refractions.udig.tools.edit.activator.DrawGeomsActivator;
import net.refractions.udig.tools.edit.activator.EditStateListenerActivator;
import net.refractions.udig.tools.edit.activator.SetRenderingFilter;
import net.refractions.udig.tools.edit.behaviour.DefaultCancelBehaviour;
import net.refractions.udig.tools.edit.behaviour.accept.AcceptChangesBehaviour;
import net.refractions.udig.tools.edit.enablement.ValidToolDetectionActivator;
import org.opengis.feature.simple.SimpleFeature;

public final class DefaultEditToolBehaviour {
    public static Set<Activator> createDefaultCreateActivators(DrawGeomsActivator.DrawType geometryType) {
        if (geometryType == null) {
            throw new NullPointerException("geomType cannot be null");
        }
        HashSet<Activator> activators = new HashSet<Activator>();
        activators.add(new EditStateListenerActivator());
        activators.add(new DrawGeomsActivator(geometryType));
        activators.add(new DrawCurrentGeomVerticesActivator());
        activators.add(new SetRenderingFilter());
        activators.add(new ClearCurrentSelectionActivator());
        return activators;
    }

    public static Set<Activator> createDefaultEditActivators(DrawGeomsActivator.DrawType geometryType) {
        if (geometryType == null) {
            throw new NullPointerException("geomType cannot be null");
        }
        HashSet<Activator> activators = new HashSet<Activator>();
        activators.add(new EditStateListenerActivator());
        activators.add(new DrawGeomsActivator(geometryType));
        activators.add(new DrawCurrentGeomVerticesActivator());
        activators.add(new SetRenderingFilter());
        return activators;
    }

    public static List<Behaviour> createAcceptAllChanges() {
        ArrayList<Behaviour> acceptBehaviours = new ArrayList<Behaviour>();
        MutualExclusiveBehavior mutualExclusive = new MutualExclusiveBehavior();
        acceptBehaviours.add(mutualExclusive);
        mutualExclusive.getBehaviours().add(new AcceptChangesBehaviour(Polygon.class, false){

            @Override
            public boolean isValid(EditToolHandler handler) {
                SimpleFeature feature = handler.getContext().getEditManager().getEditFeature();
                if (feature == null) {
                    return false;
                }
                Class<?> class1 = feature.getDefaultGeometry().getClass();
                return super.isValid(handler) && feature != null && (class1 == Polygon.class || class1 == MultiPolygon.class);
            }
        });
        mutualExclusive.getBehaviours().add(new AcceptChangesBehaviour(LineString.class, false){

            @Override
            public boolean isValid(EditToolHandler handler) {
                SimpleFeature feature = handler.getContext().getEditManager().getEditFeature();
                if (feature == null) {
                    return false;
                }
                Class<?> class1 = feature.getDefaultGeometry().getClass();
                return super.isValid(handler) && feature != null && (class1 == LineString.class || class1 == MultiLineString.class);
            }
        });
        mutualExclusive.getBehaviours().add(new AcceptChangesBehaviour(Point.class, false){

            @Override
            public boolean isValid(EditToolHandler handler) {
                SimpleFeature feature = handler.getContext().getEditManager().getEditFeature();
                if (feature == null) {
                    return false;
                }
                Class<?> class1 = feature.getDefaultGeometry().getClass();
                return super.isValid(handler) && feature != null && (class1 == Point.class || class1 == MultiPoint.class);
            }
        });
        return acceptBehaviours;
    }

    public static List<Behaviour> createDefaultAcceptBehaviour(Class<? extends Geometry> type) {
        ArrayList<Behaviour> acceptBehaviours = new ArrayList<Behaviour>();
        acceptBehaviours.add(new AcceptChangesBehaviour(type, false));
        return acceptBehaviours;
    }

    public static List<Behaviour> createDefaultCancelBehaviours() {
        ArrayList<Behaviour> cancelBehaviours = new ArrayList<Behaviour>();
        cancelBehaviours.add(new DefaultCancelBehaviour());
        return cancelBehaviours;
    }

    public static List<EnablementBehaviour> createValidToolEnablementBehaviour(Class<? extends Geometry>[] classes) {
        ArrayList<EnablementBehaviour> enablementBehaviours = new ArrayList<EnablementBehaviour>();
        enablementBehaviours.add(new ValidToolDetectionActivator(classes));
        return enablementBehaviours;
    }

    public static List<EnablementBehaviour> createEnabledWithAllGeometryLayerBehaviour() {
        Class[] classes = new Class[]{Geometry.class, LineString.class, MultiLineString.class, Polygon.class, MultiPolygon.class, Point.class, MultiPoint.class};
        return DefaultEditToolBehaviour.createValidToolEnablementBehaviour(classes);
    }
}

