/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.style;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.project.StyleContent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;

public class LocationStyleContent
extends StyleContent {
    private static final String H = "h";
    private static final String W = "w";
    private static final String Y = "y";
    private static final String X = "x";
    public static final String ID = "net.refractions.udig.printing.ui.locationStyle";
    public static final int YPAD_BOTTOM = 5;
    public static final int YPAD_TOP = 15;
    public static final int XPAD_LEFT = 15;
    public static final int XPAD_RIGHT = 15;

    public LocationStyleContent() {
        super(ID);
    }

    public Class<?> getStyleClass() {
        return Rectangle.class;
    }

    public Object load(IMemento memento) {
        int x = memento.getInteger(X);
        int y = memento.getInteger(Y);
        int width = memento.getInteger(W);
        int height = memento.getInteger(H);
        return new Rectangle(x, y, width, height);
    }

    public void save(IMemento memento, Object style) {
        Rectangle rectangle = (Rectangle)style;
        memento.putInteger(X, rectangle.x);
        memento.putInteger(Y, rectangle.y);
        memento.putInteger(W, rectangle.width);
        memento.putInteger(H, rectangle.height);
    }

    public Object createDefaultStyle(IGeoResource resource, Color colour, IProgressMonitor monitor) throws IOException {
        Rectangle rectangle;
        if (!resource.canResolve(MapGraphic.class)) {
            return null;
        }
        if (resource.canResolve(Rectangle.class) && (rectangle = (Rectangle)resource.resolve(Rectangle.class, monitor)) != null) {
            return rectangle;
        }
        return LocationStyleContent.createDefaultStyle();
    }

    public Object load(URL url, IProgressMonitor monitor) throws IOException {
        return null;
    }

    public static Rectangle createDefaultStyle() {
        return new Rectangle(15, 15, 500, 10);
    }
}

