/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.style;

import java.awt.Rectangle;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.mapgraphic.style.LocationStyleContent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.style.IStyleConfigurator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class LocationStyleConfigurator
extends IStyleConfigurator
implements SelectionListener {
    private static final String TOP = Messages.ScalebarStyleConfigurator_top;
    private static final String MIDDLE = Messages.ScalebarStyleConfigurator_middle;
    private static final String BOTTOM = Messages.ScalebarStyleConfigurator_bottom;
    private static final String LEFT = Messages.ScalebarStyleConfigurator_left;
    private static final String CENTER = Messages.ScalebarStyleConfigurator_center;
    private static final String RIGHT = Messages.ScalebarStyleConfigurator_right;
    private Combo xCombo;
    private Combo yCombo;
    private Text widthText;
    private Text heightText;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label xLabel = new Label(parent, 131072);
        xLabel.setText(Messages.ScalebarStyleConfigurator_horizontalAlignment);
        this.xCombo = new Combo(parent, 4);
        this.xCombo.setItems(new String[]{LEFT, CENTER, RIGHT});
        this.xCombo.select(0);
        this.xCombo.addSelectionListener((SelectionListener)this);
        this.xCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Label yLabel = new Label(parent, 131072);
        yLabel.setText(Messages.ScalebarStyleConfigurator_verticalAlignment);
        this.yCombo = new Combo(parent, 4);
        this.yCombo.setItems(new String[]{TOP, MIDDLE, BOTTOM});
        this.yCombo.select(0);
        this.yCombo.addSelectionListener((SelectionListener)this);
        this.yCombo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        GridData gridData = new GridData();
        Label widthLabel = new Label(parent, 0);
        widthLabel.setText(Messages.LocationStyleConfigurator_width);
        widthLabel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        this.widthText = new Text(parent, 2048);
        this.widthText.setLayoutData((Object)gridData);
        gridData = new GridData();
        Label heightLabel = new Label(parent, 0);
        heightLabel.setText(Messages.LocationStyleConfigurator_height);
        heightLabel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        this.heightText = new Text(parent, 2048);
        this.heightText.setLayoutData((Object)gridData);
    }

    public void init() {
    }

    public void refresh() {
        IBlackboard blackboard = this.getStyleBlackboard();
        Rectangle rect = (Rectangle)blackboard.get("net.refractions.udig.printing.ui.locationStyle");
        if (rect == null) {
            rect = LocationStyleContent.createDefaultStyle();
            this.setLeft(rect);
            this.setTop(rect);
            blackboard.put("net.refractions.udig.printing.ui.locationStyle", (Object)rect);
            ((StyleBlackboard)blackboard).setSelected(new String[]{"net.refractions.udig.printing.ui.locationStyle"});
        }
        if (this.isLeft(rect)) {
            this.xCombo.select(0);
        } else if (this.isCenter(rect)) {
            this.xCombo.select(1);
        } else if (this.isRight(rect)) {
            this.xCombo.select(2);
        }
        if (this.isTop(rect)) {
            this.yCombo.select(0);
        } else if (this.isMiddle(rect)) {
            this.yCombo.select(1);
        } else if (this.isBottom(rect)) {
            this.yCombo.select(2);
        }
        this.widthText.setText(Integer.toString(rect.width));
        this.heightText.setText(Integer.toString(rect.height));
    }

    public void preApply() {
        int width = Integer.parseInt(this.widthText.getText());
        int height = Integer.parseInt(this.heightText.getText());
        StyleBlackboard styleBlackboard = this.getLayer().getStyleBlackboard();
        Rectangle rec = (Rectangle)styleBlackboard.get("net.refractions.udig.printing.ui.locationStyle");
        styleBlackboard.setSelected(new String[]{"net.refractions.udig.printing.ui.locationStyle"});
        rec.setSize(width, height);
        styleBlackboard.put("net.refractions.udig.printing.ui.locationStyle", (Object)rec);
    }

    public boolean canStyle(Layer layer) {
        return layer.hasResource(MapGraphic.class);
    }

    public void widgetSelected(SelectionEvent e) {
        IBlackboard blackboard = this.getStyleBlackboard();
        Rectangle rect = (Rectangle)blackboard.get("net.refractions.udig.printing.ui.locationStyle");
        if (rect == null) {
            rect = LocationStyleContent.createDefaultStyle();
            this.setLeft(rect);
            this.setTop(rect);
            blackboard.put("net.refractions.udig.printing.ui.locationStyle", (Object)rect);
            ((StyleBlackboard)this.getStyleBlackboard()).setSelected(new String[]{"net.refractions.udig.printing.ui.locationStyle"});
        }
        switch (this.xCombo.getSelectionIndex()) {
            case 0: {
                this.setLeft(rect);
                break;
            }
            case 1: {
                this.setCenter(rect);
                break;
            }
            case 2: {
                this.setRight(rect);
            }
        }
        switch (this.yCombo.getSelectionIndex()) {
            case 0: {
                this.setTop(rect);
                break;
            }
            case 1: {
                this.setMiddle(rect);
                break;
            }
            case 2: {
                this.setBottom(rect);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected boolean isLeft(Rectangle rect) {
        return rect.x == 15;
    }

    protected void setLeft(Rectangle rect) {
        rect.x = 15;
    }

    protected boolean isCenter(Rectangle rect) {
        IMapDisplay display = this.getMapDisplay();
        int x = display.getWidth() / 2;
        return rect.x == (x -= rect.width / 2);
    }

    protected void setCenter(Rectangle rect) {
        IMapDisplay display = this.getMapDisplay();
        int x = display.getWidth() / 2;
        rect.x = x -= rect.width / 2;
    }

    protected boolean isRight(Rectangle rect) {
        return rect.x == -15;
    }

    protected void setRight(Rectangle rect) {
        rect.x = -15;
    }

    protected boolean isTop(Rectangle rect) {
        return rect.y == 15;
    }

    protected void setTop(Rectangle rect) {
        rect.y = 15;
    }

    protected boolean isMiddle(Rectangle rect) {
        IMapDisplay display = this.getMapDisplay();
        int y = display.getHeight() / 2;
        return rect.y == (y -= rect.height / 2);
    }

    protected void setMiddle(Rectangle rect) {
        IMapDisplay display = this.getMapDisplay();
        int y = display.getHeight() / 2;
        rect.y = y -= rect.height / 2;
    }

    protected boolean isBottom(Rectangle rect) {
        return rect.y == -5;
    }

    protected void setBottom(Rectangle rect) {
        rect.y = -5;
    }

    protected IMapDisplay getMapDisplay() {
        return this.getLayer().getMap().getRenderManager().getMapDisplay();
    }
}

