/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.style;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.mapgraphic.MapGraphicPlugin;
import net.refractions.udig.mapgraphic.style.FontStyle;
import net.refractions.udig.project.StyleContent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;

public class FontStyleContent
extends StyleContent {
    public static final String ID = "net.refractions.udig.mapgraphic.style.font";
    private static final String FONT_NAME = "FONT_NAME";
    private static final String STYLE = "STYLE";
    private static final String SIZE = "SIZE";

    public FontStyleContent() {
        super(ID);
    }

    public Object createDefaultStyle(IGeoResource resource, Color colour, IProgressMonitor monitor) throws IOException {
        return new FontStyle();
    }

    public Class<?> getStyleClass() {
        return FontStyle.class;
    }

    public Object load(IMemento memento) {
        try {
            if (memento.getString(FONT_NAME) != null) {
                String name = memento.getString(FONT_NAME);
                Integer style = memento.getInteger(STYLE);
                Integer size = memento.getInteger(SIZE);
                Font font = new Font(name, (int)style, size);
                return new FontStyle(font);
            }
        }
        catch (Throwable e) {
            MapGraphicPlugin.log("Error decoding the stored font", e);
        }
        return new FontStyle();
    }

    public Object load(URL url, IProgressMonitor monitor) throws IOException {
        return null;
    }

    public void save(IMemento memento, Object value) {
        FontStyle style = (FontStyle)value;
        if (style.getFont() != null) {
            memento.putString(FONT_NAME, style.getFont().getFamily());
            memento.putInteger(STYLE, style.getFont().getStyle());
            memento.putInteger(SIZE, style.getFont().getSize());
        }
    }
}

