/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.style;

import java.awt.Font;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.mapgraphic.style.FontStyle;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.style.IStyleConfigurator;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FontStyleConfigurator
extends IStyleConfigurator {
    private Text label;
    private org.eclipse.swt.graphics.Font swtFont;

    public boolean canStyle(Layer layer) {
        return layer.hasResource(MapGraphic.class) && layer.getStyleBlackboard().contains("net.refractions.udig.mapgraphic.style.font");
    }

    public void createControl(Composite parent) {
        int columns;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns = 1;
        parent.setLayout((Layout)gridLayout);
        Composite group = new Composite(parent, 0);
        group.setLayoutData((Object)new GridData(1808));
        group.setLayout((Layout)new GridLayout(2, false));
        this.label = new Text(group, 2112);
        if (this.swtFont != null) {
            this.label.setFont(this.swtFont);
        }
        this.label.setText("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
        this.label.setLayoutData((Object)new GridData(1808));
        final Button button = new Button(group, 8);
        button.setText(Messages.Font_ExampleText);
        button.setLayoutData((Object)new GridData(131072, 128, false, false));
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FontData result;
                FontDialog dialog = new FontDialog(button.getShell());
                IBlackboard blackboard = FontStyleConfigurator.this.getStyleBlackboard();
                FontStyle fontStyle = (FontStyle)blackboard.get("net.refractions.udig.mapgraphic.style.font");
                if (fontStyle != null) {
                    Font f = fontStyle.getFont();
                    FontData[] fd = AWTSWTImageUtils.awtFontToSwt((Font)f, (FontRegistry)JFaceResources.getFontRegistry()).getFontData();
                    dialog.setFontList(fd);
                }
                if ((result = dialog.open()) != null) {
                    Font awtfont = AWTSWTImageUtils.swtFontToAwt((FontData)result);
                    fontStyle.setFont(awtfont);
                    FontStyleConfigurator.this.swtFont = AWTSWTImageUtils.awtFontToSwt((Font)awtfont, (FontRegistry)JFaceResources.getFontRegistry());
                    FontStyleConfigurator.this.label.setFont(FontStyleConfigurator.this.swtFont);
                    FontStyleConfigurator.this.label.setText(FontStyleConfigurator.this.label.getText());
                }
            }
        });
    }

    protected void refresh() {
        FontStyle fontStyle = (FontStyle)this.getStyleBlackboard().get("net.refractions.udig.mapgraphic.style.font");
        if (fontStyle.getFont() != null) {
            this.swtFont = AWTSWTImageUtils.awtFontToSwt((Font)fontStyle.getFont(), (FontRegistry)JFaceResources.getFontRegistry());
            if (this.label != null) {
                this.label.setFont(this.swtFont);
            }
        }
    }
}

