/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.scalebar;

import java.awt.Rectangle;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.mapgraphic.scalebar.ScalebarMapGraphic;
import net.refractions.udig.mapgraphic.style.LocationStyleContent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.style.IStyleConfigurator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ScalebarStyleConfigurator
extends IStyleConfigurator
implements SelectionListener {
    private static final String TOP = Messages.ScalebarStyleConfigurator_top;
    private static final String MIDDLE = Messages.ScalebarStyleConfigurator_middle;
    private static final String BOTTOM = Messages.ScalebarStyleConfigurator_bottom;
    private static final String LEFT = Messages.ScalebarStyleConfigurator_left;
    private static final String CENTER = Messages.ScalebarStyleConfigurator_center;
    private static final String RIGHT = Messages.ScalebarStyleConfigurator_right;
    private Combo xCombo;
    private Combo yCombo;

    public void init() {
    }

    public void refresh() {
        IBlackboard blackboard = this.getStyleBlackboard();
        Rectangle rect = (Rectangle)blackboard.get("net.refractions.udig.printing.ui.locationStyle");
        if (rect == null) {
            rect = LocationStyleContent.createDefaultStyle();
            this.setLeft(rect);
            this.setTop(rect);
            blackboard.put("net.refractions.udig.printing.ui.locationStyle", (Object)rect);
            ((StyleBlackboard)blackboard).setSelected(new String[]{"net.refractions.udig.printing.ui.locationStyle"});
        }
        if (this.isLeft(rect)) {
            this.xCombo.select(0);
        } else if (this.isCenter(rect)) {
            this.xCombo.select(1);
        } else if (this.isRight(rect)) {
            this.xCombo.select(2);
        }
        if (this.isTop(rect)) {
            this.yCombo.select(0);
        } else if (this.isMiddle(rect)) {
            this.yCombo.select(1);
        } else if (this.isBottom(rect)) {
            this.yCombo.select(2);
        }
    }

    public void apply() {
        IBlackboard blackboard = this.getStyleBlackboard();
        Rectangle rect = (Rectangle)blackboard.get("net.refractions.udig.printing.ui.locationStyle");
        if (rect == null) {
            rect = LocationStyleContent.createDefaultStyle();
            blackboard.put("net.refractions.udig.printing.ui.locationStyle", (Object)rect);
            ((StyleBlackboard)blackboard).setSelected(new String[]{"net.refractions.udig.printing.ui.locationStyle"});
        }
    }

    public boolean canStyle(Layer layer) {
        return layer.hasResource(ScalebarMapGraphic.class);
    }

    protected boolean isLeft(Rectangle rect) {
        return rect.x == 15;
    }

    protected void setLeft(Rectangle rect) {
        rect.x = 15;
    }

    protected boolean isCenter(Rectangle rect) {
        IMapDisplay display = this.getMapDisplay();
        int x = display.getWidth() / 2;
        return rect.x == (x -= rect.width / 2);
    }

    protected void setCenter(Rectangle rect) {
        IMapDisplay display = this.getMapDisplay();
        int x = display.getWidth() / 2;
        rect.x = x -= rect.width / 2;
    }

    protected boolean isRight(Rectangle rect) {
        IMapDisplay display = this.getMapDisplay();
        int x = display.getWidth() - 15 - rect.width;
        return rect.x == x;
    }

    protected void setRight(Rectangle rect) {
        int x;
        IMapDisplay display = this.getMapDisplay();
        rect.x = x = display.getWidth() - 15 - rect.width;
    }

    protected boolean isTop(Rectangle rect) {
        return rect.y == 15 + rect.height;
    }

    protected void setTop(Rectangle rect) {
        rect.y = 15 + rect.height;
    }

    protected boolean isMiddle(Rectangle rect) {
        IMapDisplay display = this.getMapDisplay();
        int y = display.getHeight() / 2;
        return rect.y == (y -= rect.height / 2);
    }

    protected void setMiddle(Rectangle rect) {
        IMapDisplay display = this.getMapDisplay();
        int y = display.getHeight() / 2;
        rect.y = y -= rect.height / 2;
    }

    protected boolean isBottom(Rectangle rect) {
        IMapDisplay display = this.getMapDisplay();
        int y = display.getHeight() - 5 - rect.height;
        return rect.y == y;
    }

    protected void setBottom(Rectangle rect) {
        int y;
        IMapDisplay display = this.getMapDisplay();
        rect.y = y = display.getHeight() - 5 - rect.height;
    }

    protected IMapDisplay getMapDisplay() {
        return this.getLayer().getMap().getRenderManager().getMapDisplay();
    }

    public void widgetSelected(SelectionEvent e) {
        IBlackboard blackboard = this.getStyleBlackboard();
        Rectangle rect = (Rectangle)blackboard.get("net.refractions.udig.printing.ui.locationStyle");
        if (rect == null) {
            rect = LocationStyleContent.createDefaultStyle();
            this.setLeft(rect);
            this.setTop(rect);
            blackboard.put("net.refractions.udig.printing.ui.locationStyle", (Object)rect);
            ((StyleBlackboard)this.getStyleBlackboard()).setSelected(new String[]{"net.refractions.udig.printing.ui.locationStyle"});
        }
        switch (this.xCombo.getSelectionIndex()) {
            case 0: {
                this.setLeft(rect);
                break;
            }
            case 1: {
                this.setCenter(rect);
                break;
            }
            case 2: {
                this.setRight(rect);
            }
        }
        switch (this.yCombo.getSelectionIndex()) {
            case 0: {
                this.setTop(rect);
                break;
            }
            case 1: {
                this.setMiddle(rect);
                break;
            }
            case 2: {
                this.setBottom(rect);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, true));
        Label xLabel = new Label(parent, 131072);
        xLabel.setText(Messages.ScalebarStyleConfigurator_horizontalAlignment);
        this.xCombo = new Combo(parent, 4);
        this.xCombo.setItems(new String[]{LEFT, CENTER, RIGHT});
        this.xCombo.select(0);
        this.xCombo.addSelectionListener((SelectionListener)this);
        Label yLabel = new Label(parent, 131072);
        yLabel.setText(Messages.ScalebarStyleConfigurator_verticalAlignment);
        this.yCombo = new Combo(parent, 4);
        this.yCombo.setItems(new String[]{TOP, MIDDLE, BOTTOM});
        this.yCombo.select(0);
        this.yCombo.addSelectionListener((SelectionListener)this);
    }
}

