/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.scalebar;

import java.awt.Color;
import java.awt.Font;
import java.text.NumberFormat;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.mapgraphic.scalebar.ScaleDenomMapGraphicBean;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.ui.graphics.ViewportGraphics;

public class ScaleDenomMapGraphic
implements MapGraphic {
    @Override
    public void draw(MapGraphicContext context) {
        int anchorPointX;
        int horizAlignment;
        ScaleDenomMapGraphicBean configBean = this.getConfigBean(context.getLayer().getStyleBlackboard());
        if (configBean.getFont() == null) {
            throw new NullPointerException("ScaleDenomMapGraphicBean font must not be null");
        }
        if (configBean.getTextColor() == null) {
            throw new NullPointerException("ScaleDenomMapGraphicBean text color must not be null");
        }
        if (configBean.getNumberFormat() == null) {
            throw new NullPointerException("ScaleDenomMapGraphicBean number format must not be null");
        }
        if (configBean.getWidth() <= 0) {
            throw new IllegalArgumentException("ScaleDenomMapGraphicBean width must be a positive number");
        }
        if (configBean.getHeight() <= 0) {
            throw new IllegalArgumentException("ScaleDenomMapGraphicBean height must be a positive number");
        }
        if (configBean.getLabel() == null) {
            throw new NullPointerException("ScaleDenomMapGraphicBean label must not be null");
        }
        ViewportGraphics g = context.getGraphics();
        IBlackboard mapblackboard = context.getMap().getBlackboard();
        double scaleDenom = context.getViewportModel().getScaleDenominator();
        Object value = mapblackboard.get("scale");
        if (value != null && value instanceof Double) {
            scaleDenom = (Double)value;
        }
        if (configBean.getBackgroundColor() != null) {
            g.setBackground(configBean.getBackgroundColor());
            g.clearRect(0, 0, configBean.getWidth(), configBean.getHeight());
        }
        g.setColor(configBean.getTextColor());
        g.setFont(configBean.getFont());
        String denomStr = configBean.getNumberFormat().format(scaleDenom);
        if (configBean.getHorizAlignment() == 2) {
            horizAlignment = 0;
            anchorPointX = configBean.getWidth() / 2;
        } else if (configBean.getHorizAlignment() == 1) {
            horizAlignment = 1;
            anchorPointX = configBean.getWidth();
        } else {
            horizAlignment = -1;
            anchorPointX = 0;
        }
        g.drawString(String.valueOf(configBean.getLabel()) + "1:" + denomStr, anchorPointX, configBean.getHeight() / 2, horizAlignment, 0);
    }

    private ScaleDenomMapGraphicBean getConfigBean(IStyleBlackboard styleBlackboard) {
        ScaleDenomMapGraphicBean configBean = (ScaleDenomMapGraphicBean)styleBlackboard.get("net.refractions.udig.mapgraphic.scalebar.ScaleDenomMapGraphic");
        if (configBean == null) {
            configBean = new ScaleDenomMapGraphicBean();
            configBean.setFont(new Font("Arial", 0, 10));
            configBean.setWidth(150);
            configBean.setHeight(40);
            configBean.setTextColor(Color.BLACK);
            configBean.setBackgroundColor(Color.WHITE);
            configBean.setLabel("");
            configBean.setHorizAlignment(2);
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(0);
            configBean.setNumberFormat(nf);
        }
        return configBean;
    }
}

