/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.scalebar;

import java.awt.Color;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.mapgraphic.scalebar.BarStyle;
import net.refractions.udig.mapgraphic.scalebar.UnitPolicy;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.internal.dialogs.ColorEditor;
import net.refractions.udig.style.IStyleConfigurator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;

public class BarStyleConfigurator
extends IStyleConfigurator
implements SelectionListener,
ISelectionChangedListener {
    private Spinner divSpinner = null;
    private ColorEditor chooser = null;
    private TableViewer tViewer;
    private Combo cmbUnits;

    public boolean canStyle(Layer layer) {
        return layer.hasResource(MapGraphic.class) && layer.getStyleBlackboard().contains("net.refractions.udig.mapgraphic.style.bartype");
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(parent, 0);
        label.setText(Messages.BarStyleConfigurator_barstylelabel);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        Table table = new Table(parent, 2820);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        table.setLayoutData((Object)new GridData(235, 45));
        this.tViewer = new TableViewer(table);
        TableViewerColumn c = new TableViewerColumn(this.tViewer, 16384);
        c.getColumn().setResizable(false);
        c.getColumn().setWidth(250);
        c.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((BarStyle.BarType)((Object)element)).getName();
            }

            public Image getImage(Object element) {
                BarStyle.BarType bt = (BarStyle.BarType)((Object)element);
                return bt.getImage();
            }
        });
        this.tViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return BarStyle.getTypes();
            }
        });
        this.tViewer.setInput((Object)BarStyle.getTypes());
        this.tViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        label = new Label(parent, 131072);
        label.setText(Messages.BarStyleConfigurator_divisionslabel);
        label.setLayoutData((Object)new GridData());
        this.divSpinner = new Spinner(parent, 2048);
        this.divSpinner.setMaximum(20);
        this.divSpinner.setMinimum(2);
        this.divSpinner.setIncrement(1);
        this.divSpinner.addSelectionListener((SelectionListener)this);
        label = new Label(parent, 131072);
        label.setText(Messages.BarStyleConfigurator_colorlable);
        label.setLayoutData((Object)new GridData());
        this.chooser = new ColorEditor(parent);
        this.chooser.addSelectionListener((SelectionListener)this);
        label = new Label(parent, 131072);
        label.setText(Messages.BarStyleConfigurator_UnitsLabel);
        label.setLayoutData((Object)new GridData());
        this.cmbUnits = new Combo(parent, 4);
        this.cmbUnits.setItems(new String[]{UnitPolicy.AUTO.getLabel(), UnitPolicy.METRIC.getLabel(), UnitPolicy.IMPERIAL.getLabel()});
        this.cmbUnits.select(0);
        this.cmbUnits.setLayoutData((Object)new GridData());
        this.cmbUnits.addSelectionListener((SelectionListener)this);
    }

    protected void refresh() {
        BarStyle barStyle = (BarStyle)this.getStyleBlackboard().get("net.refractions.udig.mapgraphic.style.bartype");
        if (this.divSpinner != null) {
            this.divSpinner.setSelection(barStyle.getNumintervals());
        }
        if (this.tViewer != null) {
            int i = 0;
            while (i < this.tViewer.getTable().getItemCount()) {
                if ((BarStyle.BarType)((Object)this.tViewer.getTable().getItem(i).getData()) == barStyle.getType()) {
                    this.tViewer.getTable().setSelection(i);
                    break;
                }
                ++i;
            }
        }
        if (this.chooser != null) {
            Color c = barStyle.getColor();
            this.chooser.setColorValue(new RGB(c.getRed(), c.getGreen(), c.getBlue()));
        }
        if (barStyle.getUnits() == UnitPolicy.METRIC) {
            this.cmbUnits.select(1);
        } else if (barStyle.getUnits() == UnitPolicy.IMPERIAL) {
            this.cmbUnits.select(2);
        } else {
            this.cmbUnits.select(0);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateStyle();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateStyle();
    }

    private void updateStyle() {
        BarStyle barStyle = (BarStyle)this.getStyleBlackboard().get("net.refractions.udig.mapgraphic.style.bartype");
        RGB rgb = this.chooser.getColorValue();
        barStyle.setColor(new Color(rgb.red, rgb.green, rgb.blue));
        barStyle.setNumIntervals(this.divSpinner.getSelection());
        if (this.tViewer.getTable().getSelection().length > 0) {
            barStyle.setType((BarStyle.BarType)((Object)this.tViewer.getTable().getSelection()[0].getData()));
        }
        if (this.cmbUnits.getSelectionIndex() == 1) {
            barStyle.setUnits(UnitPolicy.METRIC);
        } else if (this.cmbUnits.getSelectionIndex() == 2) {
            barStyle.setUnits(UnitPolicy.IMPERIAL);
        } else {
            barStyle.setUnits(UnitPolicy.AUTO);
        }
    }
}

