/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.northarrow;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.ui.internal.commands.draw.DrawShapeCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.AbstractModalTool;

public class NorthArrowTool
extends AbstractModalTool {
    public static final String STYLE_BLACKBOARD_KEY = "net.refractions.udig.tool.northarrow-style";
    private DrawShapeCommand command;

    public NorthArrowTool() {
        super(3);
    }

    public void mouseReleased(MapMouseEvent e) {
        this.command.setValid(false);
        this.getContext().getViewportPane().repaint();
        IStyleBlackboard styleBlackboard = this.getContext().getSelectedLayer().getStyleBlackboard();
        styleBlackboard.put(STYLE_BLACKBOARD_KEY, (Object)e.getPoint());
        this.getContext().getSelectedLayer().refresh(null);
    }

    public void mouseDragged(MapMouseEvent e) {
        Rectangle2D rect = (Rectangle2D)this.command.getShape();
        double w = rect.getWidth();
        double h = rect.getHeight();
        rect.setRect(e.x, (double)e.y - h, w, h);
        this.getContext().getViewportPane().repaint();
    }

    public void mousePressed(MapMouseEvent e) {
        Rectangle2D.Double r = new Rectangle2D.Double(e.x, e.y - 14, 1.0, 14.0);
        this.command = this.getContext().getDrawFactory().createDrawShapeCommand((Shape)r);
        this.getContext().sendASyncCommand((Command)this.command);
        this.getContext().getSelectedLayer().refresh(null);
    }
}

