/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.internal;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicFactory;
import net.refractions.udig.mapgraphic.internal.MapGraphicService;
import net.refractions.udig.mapgraphic.internal.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapGraphicResource
extends IGeoResource {
    private final MapGraphicService parent;
    private String name;
    private final String id;
    private IConfigurationElement element;
    private MapGraphic mapgraphic;

    MapGraphicResource(MapGraphicService service, IConfigurationElement element) {
        this.service = service;
        this.parent = service;
        this.name = element.getAttribute("name");
        this.id = element.getAttribute("id");
        this.element = element;
        this.mapgraphic = this.createMapGraphic();
    }

    private MapGraphic createMapGraphic() {
        return MapGraphicFactory.getInstance().createMapGraphic(this.id);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast((Object)this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(MapGraphic.class)) {
            return adaptee.cast(this.getMapGraphic());
        }
        if (adaptee.isAssignableFrom(MapGraphicFactory.class)) {
            return adaptee.cast(MapGraphicFactory.getInstance());
        }
        if (this.mapgraphic != null && adaptee.isAssignableFrom(this.mapgraphic.getClass())) {
            return adaptee.cast(this.createMapGraphic());
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public MapGraphic getMapGraphic() {
        return this.mapgraphic;
    }

    public MapGraphicResourceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (MapGraphicResourceInfo)super.getInfo(monitor);
    }

    protected MapGraphicResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        return new MapGraphicResourceInfo(this.element);
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee != null && (adaptee.isAssignableFrom(this.element.getClass()) || adaptee.isAssignableFrom(IService.class) || adaptee.isAssignableFrom(IGeoResource.class) || adaptee.isAssignableFrom(MapGraphic.class) || adaptee.isAssignableFrom(MapGraphicFactory.class) || this.getMapGraphic() != null && adaptee.isAssignableFrom(this.getMapGraphic().getClass())) || super.canResolve(adaptee);
    }

    public IResolve.Status getStatus() {
        return this.parent.getStatus();
    }

    public Throwable getMessage() {
        return this.parent.getMessage();
    }

    public URL getIdentifier() {
        try {
            return new URL(null, String.valueOf(this.parent.getIdentifier().toString()) + "#" + this.id, CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public MapGraphic getGraphic() {
        return this.getMapGraphic();
    }

    class MapGraphicResourceInfo
    extends IGeoResourceInfo {
        public MapGraphicResourceInfo(IConfigurationElement element) {
            String iconPath = element.getAttribute("icon");
            if (iconPath != null && iconPath.length() > 0) {
                this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getNamespaceIdentifier(), (String)iconPath);
            }
        }

        public String getName() {
            return MapGraphicResource.this.name;
        }

        public CoordinateReferenceSystem getCRS() {
            return DefaultGeographicCRS.WGS84;
        }

        public String getTitle() {
            return this.getName();
        }

        public String getDescription() {
            MessageFormat formatter = new MessageFormat(Messages.MapGraphicResource_description);
            return formatter.format(this.name);
        }

        public ReferencedEnvelope getBounds() {
            if (this.bounds == null) {
                Envelope e = new Envelope();
                e.setToNull();
                this.bounds = new ReferencedEnvelope(e, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            }
            return this.bounds;
        }
    }
}

