/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.grid;

import net.refractions.udig.mapgraphic.grid.GridStyleConfigurator;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

class SpacerController {
    private final Spinner spinner;
    private final Combo unit;
    static final String PIXELS = "pixels";
    static final String DEGREES = "degrees";
    static final String MINUTES = "minutes";
    static final String SECONDS = "seconds";
    static final String[] UNITS = new String[]{"pixels", "degrees", "minutes", "seconds"};

    public SpacerController(Spinner spinner, Combo unit) {
        this.spinner = spinner;
        this.unit = unit;
        this.unit.setItems(UNITS);
        this.unit.select(0);
    }

    public Spinner getSpinner() {
        return this.spinner;
    }

    public Combo getUnit() {
        return this.unit;
    }

    public static double spinnerUnit(int digitsInSpinner) {
        return Math.pow(10.0, digitsInSpinner);
    }

    private void setSpinner(int inc, int max, int digits, int pageinc) {
        this.spinner.setIncrement(inc);
        this.spinner.setMaximum(max);
        this.spinner.setDigits(digits);
        this.spinner.setPageIncrement(pageinc);
    }

    public void setSpinnerProperties() {
        if (GridStyleConfigurator.selectedString(this.unit).equals(PIXELS)) {
            this.setSpinner(1, Integer.MAX_VALUE, 0, 10);
        } else if (GridStyleConfigurator.selectedString(this.unit).equals(MINUTES)) {
            this.setSpinner((int)SpacerController.spinnerUnit(4), (int)(21600.0 * SpacerController.spinnerUnit(4)), 4, 60);
        } else if (GridStyleConfigurator.selectedString(this.unit).equals(SECONDS)) {
            this.setSpinner((int)SpacerController.spinnerUnit(2), (int)(1296000.0 * SpacerController.spinnerUnit(2)), 2, 3600);
        } else if (GridStyleConfigurator.selectedString(this.unit).equals(DEGREES)) {
            this.setSpinner((int)SpacerController.spinnerUnit(6), (int)(360.0 * SpacerController.spinnerUnit(6)), 6, 10);
        }
    }

    public boolean validateWorld(SpacerController otherSpacer) {
        if (otherSpacer.isPixelsSelected()) {
            otherSpacer.getUnit().select(this.unit.getSelectionIndex());
            return true;
        }
        return false;
    }

    public boolean validatePixels(SpacerController otherSpacer) {
        if (!otherSpacer.isPixelsSelected()) {
            otherSpacer.getUnit().select(otherSpacer.getUnit().indexOf(PIXELS));
            return true;
        }
        return false;
    }

    public boolean isPixelsSelected() {
        return GridStyleConfigurator.selectedString(this.getUnit()).equals(PIXELS);
    }

    public void addListeners(ModifyListener modifyListener, Listener listener) {
        this.unit.addModifyListener(modifyListener);
        this.unit.addListener(24, listener);
        this.spinner.addListener(24, listener);
        this.spinner.addListener(2, listener);
    }

    public void removeListeners(ModifyListener modifyListener, Listener listener) {
        this.unit.removeModifyListener(modifyListener);
        this.unit.removeListener(24, listener);
        this.spinner.removeListener(24, listener);
        this.spinner.removeListener(2, listener);
    }

    public void setWorldSpacing(double value) {
        double unitValue = SpacerController.spinnerUnit(this.spinner.getDigits());
        if (GridStyleConfigurator.selectedString(this.unit).equals(DEGREES)) {
            this.spinner.setSelection((int)(value * unitValue));
        } else if (GridStyleConfigurator.selectedString(this.unit).equals(MINUTES)) {
            this.spinner.setSelection((int)(value * 60.0 * unitValue));
        } else if (GridStyleConfigurator.selectedString(this.unit).equals(SECONDS)) {
            this.spinner.setSelection((int)(value * 3600.0 * unitValue));
        } else if (GridStyleConfigurator.selectedString(this.unit).equals(PIXELS)) {
            this.unit.select(this.unit.indexOf(DEGREES));
            this.setSpinnerProperties();
            this.spinner.setSelection((int)value);
        }
    }

    public void setPixelSpacing(double spacing) {
        this.unit.select(this.unit.indexOf(PIXELS));
        this.setSpinnerProperties();
        this.spinner.setSelection((int)spacing);
    }

    public double getSpacing() {
        double selection = (double)this.spinner.getSelection() / SpacerController.spinnerUnit(this.spinner.getDigits());
        if (GridStyleConfigurator.selectedString(this.unit).equals(MINUTES)) {
            return selection / 60.0;
        }
        if (GridStyleConfigurator.selectedString(this.unit).equals(SECONDS)) {
            return selection / 3600.0;
        }
        return selection;
    }
}

