/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.grid;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Color;
import java.awt.Point;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.mapgraphic.MapGraphicPlugin;
import net.refractions.udig.mapgraphic.grid.GridStyle;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class GridMapGraphic
implements MapGraphic {
    @Override
    public void draw(MapGraphicContext context) {
        ViewportGraphics graphics = context.getGraphics();
        GridStyle style = this.getStyle(context.getLayer());
        graphics.setColor(style.getColor());
        graphics.setStroke(style.getLineStyle(), style.getLineWidth());
        switch (this.getStyle(context.getLayer()).getType()) {
            case SCREEN: {
                this.screenMapGraphic(context);
                break;
            }
            case WORLD: {
                if (style.isCenterGrid()) {
                    this.worldCenteredGridMapGraphic(context, style.isShowLabels());
                    break;
                }
                this.worldMapGraphic(context);
                break;
            }
            default: {
                throw new AssertionError((Object)("Should be impossible to reach here: " + (Object)((Object)this.getStyle(context.getLayer()).getType())));
            }
        }
    }

    private void screenMapGraphic(MapGraphicContext context) {
        GridStyle style = this.getStyle(context.getLayer());
        double[] gridSize = style.getGridSize();
        int dx = (int)gridSize[0];
        int dy = (int)gridSize[1];
        int width = context.getMapDisplay().getWidth();
        int height = context.getMapDisplay().getHeight();
        ViewportGraphics g = context.getGraphics();
        int x = 0;
        int y = 0;
        while (x < width) {
            g.drawLine(x += dx, 0, x, height);
        }
        while (y < height) {
            g.drawLine(0, y += dy, width, y);
        }
    }

    private void worldMapGraphic(MapGraphicContext context) {
        GridStyle style = this.getStyle(context.getLayer());
        double[] gridSize = style.getGridSize();
        try {
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)context.getCRS(), (boolean)true);
            if (!mt.isIdentity()) {
                double x = gridSize[0] / 2.0;
                double y = gridSize[1] / 2.0;
                double[] toTransform = new double[]{-x, -y, x, y};
                double[] dest = new double[4];
                mt.transform(toTransform, 0, dest, 0, 2);
                gridSize = new double[]{Math.abs(dest[2] - dest[0]), Math.abs(dest[3] - dest[1])};
            }
        }
        catch (Exception e) {
            MapGraphicPlugin.log("", e);
        }
        ReferencedEnvelope bounds = context.getViewportModel().getBounds();
        double newx = (double)Math.round(bounds.getMinX() / gridSize[0]) * gridSize[0];
        double newy = (double)Math.round(bounds.getMaxY() / gridSize[1]) * gridSize[1];
        Coordinate coord = new Coordinate(newx, newy);
        while (context.worldToPixel((Coordinate)coord).x < 0) {
            coord.x += gridSize[0];
        }
        while (context.worldToPixel((Coordinate)coord).y < 0) {
            coord.y -= gridSize[1];
        }
        ViewportGraphics graphics = context.getGraphics();
        Point pixel = null;
        while (true) {
            pixel = context.worldToPixel(coord);
            coord.x += gridSize[0];
            coord.y -= gridSize[1];
            Point next = context.worldToPixel(coord);
            if (next.x - pixel.x < 2 || next.y - pixel.y < 2) {
                context.getLayer().setStatus(4);
                context.getLayer().setStatusMessage(Messages.GridMapGraphic_grids_too_close);
                break;
            }
            if (pixel.x >= context.getMapDisplay().getWidth() && pixel.y >= context.getMapDisplay().getHeight()) break;
            if (pixel.x < context.getMapDisplay().getWidth()) {
                graphics.drawLine(pixel.x, 0, pixel.x, context.getMapDisplay().getHeight());
            }
            if (pixel.y < context.getMapDisplay().getHeight()) {
                graphics.drawLine(0, pixel.y, context.getMapDisplay().getWidth(), pixel.y);
            }
            pixel = next;
        }
    }

    private void worldCenteredGridMapGraphic(MapGraphicContext context, boolean showLabels) {
        GridStyle style = this.getStyle(context.getLayer());
        double[] gridSize = style.getGridSize();
        try {
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)context.getCRS(), (boolean)true);
            if (!mt.isIdentity()) {
                double x = gridSize[0] / 2.0;
                double y = gridSize[1] / 2.0;
                double[] toTransform = new double[]{-x, -y, x, y};
                double[] dest = new double[4];
                mt.transform(toTransform, 0, dest, 0, 2);
                gridSize = new double[]{Math.abs(dest[2] - dest[0]), Math.abs(dest[3] - dest[1])};
            }
        }
        catch (Exception e) {
            MapGraphicPlugin.log("", e);
        }
        ReferencedEnvelope bounds = context.getViewportModel().getBounds();
        Coordinate centerCoord = bounds.centre();
        gridSize = style.getGridSize();
        Coordinate topLeftCenterCoord = new Coordinate(centerCoord.x - gridSize[0] / 2.0, centerCoord.y + gridSize[1] / 2.0);
        Coordinate topLeftMostCoord = new Coordinate(topLeftCenterCoord);
        while (topLeftMostCoord.x - gridSize[0] > bounds.getMinX()) {
            topLeftMostCoord.x -= gridSize[0];
        }
        while (topLeftMostCoord.y + gridSize[1] < bounds.getMaxY()) {
            topLeftMostCoord.y += gridSize[1];
        }
        Coordinate coord = topLeftMostCoord;
        ViewportGraphics graphics = context.getGraphics();
        int mapPixelWidth = context.getMapDisplay().getWidth();
        int mapPixelHeight = context.getMapDisplay().getHeight();
        int RIGHT_STRIP_WIDTH = (int)((double)mapPixelWidth * 0.05);
        int BOTTOM_STRIP_HEIGHT = (int)((double)mapPixelHeight * 0.03);
        int GRID_LINE_EXTENSION = (int)((double)RIGHT_STRIP_WIDTH * 0.1);
        graphics.setColor(Color.white);
        graphics.fillRect(mapPixelWidth - RIGHT_STRIP_WIDTH, 0, RIGHT_STRIP_WIDTH, mapPixelHeight);
        graphics.fillRect(0, mapPixelHeight - BOTTOM_STRIP_HEIGHT, mapPixelWidth, BOTTOM_STRIP_HEIGHT);
        graphics.setColor(style.getColor());
        Point pixel = null;
        while (true) {
            pixel = context.worldToPixel(coord);
            coord.x += gridSize[0];
            coord.y -= gridSize[1];
            Point next = context.worldToPixel(coord);
            if (next.x - pixel.x < 2 || next.y - pixel.y < 2) {
                context.getLayer().setStatus(4);
                context.getLayer().setStatusMessage(Messages.GridMapGraphic_grids_too_close);
                break;
            }
            if (pixel.x >= mapPixelWidth && pixel.y >= mapPixelHeight) break;
            if (pixel.x < mapPixelWidth) {
                graphics.drawLine(pixel.x, 0, pixel.x, mapPixelHeight - BOTTOM_STRIP_HEIGHT + GRID_LINE_EXTENSION);
            }
            if (showLabels) {
                graphics.drawString(String.valueOf((int)coord.y), pixel.x, mapPixelHeight - BOTTOM_STRIP_HEIGHT + GRID_LINE_EXTENSION, 0, 1);
            }
            if (pixel.y < mapPixelHeight) {
                graphics.drawLine(0, pixel.y, mapPixelWidth - RIGHT_STRIP_WIDTH + GRID_LINE_EXTENSION, pixel.y);
            }
            if (showLabels) {
                graphics.drawString(String.valueOf((int)coord.x), mapPixelWidth - RIGHT_STRIP_WIDTH + GRID_LINE_EXTENSION, pixel.y, -1, 0);
            }
            pixel = next;
        }
        graphics.drawRect(0, 0, mapPixelWidth - RIGHT_STRIP_WIDTH, mapPixelHeight - BOTTOM_STRIP_HEIGHT);
    }

    private GridStyle getStyle(ILayer layer) {
        GridStyle gridStyle = (GridStyle)layer.getStyleBlackboard().get("net.refractions.udig.tool.edit.mapgraphic.grid.style");
        if (gridStyle == null) {
            return GridStyle.DEFAULT_STYLE;
        }
        return gridStyle;
    }

    public double[] closest(int x, int y, ILayer layer) throws FactoryException {
        switch (this.getStyle(layer).getType()) {
            case SCREEN: {
                return this.screenClosest(x, y, layer);
            }
            case WORLD: {
                return this.worldClosest(x, y, layer);
            }
        }
        AssertionError e = new AssertionError((Object)("Should be impossible to reach here: " + (Object)((Object)this.getStyle(layer).getType())));
        MapGraphicPlugin.log(null, (Throwable)((Object)e));
        throw e;
    }

    private double[] screenClosest(int x, int y, ILayer layer) {
        double[] gridSize = this.getStyle(layer).getGridSize();
        double newx = (double)Math.round((double)x / gridSize[0]) * gridSize[0];
        double newy = (double)Math.round((double)y / gridSize[1]) * gridSize[1];
        Coordinate result = layer.getMap().getViewportModel().pixelToWorld((int)newx, (int)newy);
        return new double[]{result.x, result.y};
    }

    private double[] worldClosest(int x1, int y1, ILayer layer) throws FactoryException {
        Coordinate coord = layer.getMap().getViewportModel().pixelToWorld(x1, y1);
        CoordinateReferenceSystem crs = layer.getMap().getViewportModel().getCRS();
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs);
        double[] gridSize = this.getStyle(layer).getGridSize();
        try {
            if (!mt.isIdentity()) {
                double tx = gridSize[0] / 2.0;
                double ty = gridSize[1] / 2.0;
                double[] toTransform = new double[]{-tx, -ty, tx, ty};
                double[] dest = new double[4];
                mt.transform(toTransform, 0, dest, 0, 2);
                gridSize = new double[]{Math.abs(dest[2] - dest[0]), Math.abs(dest[3] - dest[1])};
            }
        }
        catch (Exception e) {
            MapGraphicPlugin.log("", e);
        }
        double newx = (double)Math.round(coord.x / gridSize[0]) * gridSize[0];
        double newy = (double)Math.round(coord.y / gridSize[1]) * gridSize[1];
        return new double[]{newx, newy};
    }
}

