/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.graticule;

import java.awt.Color;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.mapgraphic.style.FontStyle;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IStyleBlackboard;

public class GraticuleStyle {
    private static final String EPSG_4326 = "EPSG:4326";
    public static final String ID = "net.refractions.udig.tool.edit.mapgraphic.graticule.style";
    public static final GraticuleStyle DEFAULT = new GraticuleStyle(new Color(0, 180, 255, 100), new Color(0, 180, 255, 100), 100, 1, 1, true, true, "EPSG:4326");
    private int opacity;
    private Color lineColor;
    private int lineStyle;
    private int lineWidth;
    private Boolean isShowLabels;
    private Color fontColor;
    private Boolean isInitCRS;
    private String crs;

    public GraticuleStyle(Color fontColor, Color lineColor, int opacity, int lineStyle, int lineWidth, Boolean isShowLabels, Boolean isInitCRS, String crs) {
        this.opacity = opacity;
        this.fontColor = fontColor;
        this.lineColor = lineColor;
        this.lineStyle = lineStyle;
        this.lineWidth = lineWidth;
        this.isShowLabels = isShowLabels;
        this.isInitCRS = isInitCRS;
        this.crs = crs;
    }

    public GraticuleStyle(GraticuleStyle oldStyle) {
        this.opacity = oldStyle.getOpacity();
        this.fontColor = oldStyle.getFontColor();
        this.lineColor = oldStyle.getLineColor();
        this.lineStyle = oldStyle.getLineStyle();
        this.lineWidth = oldStyle.getLineWidth();
        this.isShowLabels = oldStyle.isShowLabels();
        this.isInitCRS = oldStyle.isInitCRS();
        this.crs = oldStyle.getCRS();
    }

    public Color getFontColor() {
        return new Color(this.fontColor.getRed(), this.fontColor.getGreen(), this.fontColor.getBlue(), this.getOpacity());
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public Color getLineColor() {
        return new Color(this.lineColor.getRed(), this.lineColor.getGreen(), this.lineColor.getBlue(), this.getOpacity());
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int opacity) {
        this.opacity = opacity;
    }

    public boolean isShowLabels() {
        return this.isShowLabels != null ? this.isShowLabels : false;
    }

    public void setShowLabels(boolean isShowLabels) {
        this.isShowLabels = isShowLabels;
    }

    public boolean isInitCRS() {
        return this.isInitCRS != null ? this.isInitCRS : true;
    }

    public void setInitCRS(boolean isInitCRS) {
        this.isInitCRS = isInitCRS;
    }

    public String getCRS() {
        return this.crs != null ? this.crs : EPSG_4326;
    }

    public void setCRS(String crs) {
        this.crs = crs;
    }

    public static final GraticuleStyle getStyle(ILayer layer) {
        GraticuleStyle style = (GraticuleStyle)layer.getStyleBlackboard().get(ID);
        if (style == null) {
            return DEFAULT;
        }
        return style;
    }

    public static FontStyle getFontStyle(MapGraphicContext context) {
        IStyleBlackboard styleBlackboard = context.getLayer().getStyleBlackboard();
        FontStyle style = (FontStyle)styleBlackboard.get("net.refractions.udig.mapgraphic.style.font");
        if (style == null) {
            style = new FontStyle();
            styleBlackboard.put("net.refractions.udig.mapgraphic.style.font", (Object)style);
        }
        return style;
    }
}

