/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.graticule;

import java.awt.Color;
import net.refractions.udig.mapgraphic.graticule.ColorListener;
import net.refractions.udig.mapgraphic.graticule.GraticuleGraphic;
import net.refractions.udig.mapgraphic.graticule.GraticuleStyle;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.internal.dialogs.ColorEditor;
import net.refractions.udig.style.IStyleConfigurator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;

public class GraticuleLinesConfigurator
extends IStyleConfigurator
implements Listener {
    private static final String LINE_DASH = "dash";
    private static final String LINE_DASHDOT = "dash-dot";
    private static final String LINE_DASHDOTDOT = "dash-dot-dot";
    private static final String LINE_DOT = "dot";
    private static final String LINE_SOLID = "solid";
    private static final String[] LINE_STYLES = new String[]{"solid", "dash", "dot", "dash-dot", "dash-dot-dot"};
    Combo lineStyle;
    private ColorEditor fontColor;
    private ColorEditor lineColor;
    Button showLabels;
    Spinner lineWidth;
    Scale opacity;
    Label messageLabel;
    Label fontColorLabel;
    Label lineColorLabel;
    Label lineStyleLabel;
    Label lineWidthLabel;
    Label showLabelsLabel;
    Label opacityLabel;
    private GraticuleStyle style;
    private ColorListener colorListener;
    private Composite container;

    public boolean canStyle(Layer aLayer) {
        return aLayer.hasResource(GraticuleGraphic.class) && aLayer.getStyleBlackboard().get("net.refractions.udig.tool.edit.mapgraphic.graticule.style") != null;
    }

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite widgets = this.createWidgets(parent);
        this.addListeners();
        this.layoutWidgets(widgets);
    }

    protected GraticuleStyle getStyle() {
        return this.style;
    }

    private void layoutWidgets(Composite comp) {
        comp.setLayout((Layout)new GridLayout(4, false));
        GridData layoutData = new GridData(4, 4, false, false, 1, 1);
        this.fontColorLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(0, 4, true, false, 3, 1);
        this.fontColor.getButton().setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, false, 1, 1);
        this.lineColorLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(0, 4, true, false, 3, 1);
        this.lineColor.getButton().setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 0x1000000, false, false, 1, 1);
        layoutData.heightHint = 20;
        this.opacityLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, false, 3, 1);
        layoutData.heightHint = 20;
        this.opacity.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, false, 1, 1);
        this.lineStyleLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, false, 3, 1);
        this.lineStyle.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, false, 1, 1);
        this.lineWidthLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, false, 3, 1);
        this.lineWidth.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, false, false, 1, 1);
        this.showLabelsLabel.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, false, 3, 1);
        this.showLabels.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, true, 4, 1);
        this.messageLabel.setLayoutData((Object)layoutData);
    }

    private void addListeners() {
        this.colorListener = new ColorListener(this);
        this.fontColor.addSelectionListener((SelectionListener)this.colorListener);
        this.lineColor.addSelectionListener((SelectionListener)this.colorListener);
        this.lineStyle.addListener(24, (Listener)this);
        this.lineStyle.addListener(2, (Listener)this);
        this.lineWidth.addListener(24, (Listener)this);
        this.lineWidth.addListener(2, (Listener)this);
        this.showLabels.addListener(13, (Listener)this);
        this.opacity.addListener(13, (Listener)this);
    }

    private void removeListeners() {
        this.fontColor.removeSelectionListener((SelectionListener)this.colorListener);
        this.lineColor.removeSelectionListener((SelectionListener)this.colorListener);
        this.lineStyle.removeListener(24, (Listener)this);
        this.lineWidth.removeListener(24, (Listener)this);
        this.lineStyle.removeListener(2, (Listener)this);
        this.lineWidth.removeListener(2, (Listener)this);
        this.showLabels.removeListener(13, (Listener)this);
        this.opacity.removeListener(13, (Listener)this);
    }

    private Composite createWidgets(Composite parent) {
        this.container = new Composite(parent, 0);
        this.fontColorLabel = new Label(this.container, 0);
        this.fontColorLabel.setText(Messages.GraticuleStyleConfigurator_Font_Color);
        this.fontColor = new ColorEditor(this.container);
        this.lineColorLabel = new Label(this.container, 0);
        this.lineColorLabel.setText(Messages.GridStyleConfigurator_LineColor);
        this.lineColor = new ColorEditor(this.container);
        this.opacityLabel = new Label(this.container, 0);
        this.opacityLabel.setText(Messages.GraticuleStyleConfigurator_Opacity);
        this.opacity = new Scale(this.container, 2048);
        this.opacity.setMaximum(255);
        this.opacity.setPageIncrement(5);
        this.opacity.setSelection(100);
        this.lineStyleLabel = new Label(this.container, 0);
        this.lineStyleLabel.setText(Messages.GridStyleConfigurator_LineStyle);
        this.lineStyle = new Combo(this.container, 0);
        this.lineStyle.setItems(LINE_STYLES);
        this.lineStyle.select(0);
        this.lineWidthLabel = new Label(this.container, 0);
        this.lineWidthLabel.setText(Messages.GridStyleConfigurator_LineWidth);
        this.lineWidth = new Spinner(this.container, 2048);
        this.lineWidth.setIncrement(1);
        this.lineWidth.setDigits(0);
        this.lineWidth.setMinimum(1);
        this.showLabelsLabel = new Label(this.container, 0);
        this.showLabelsLabel.setText(Messages.GraticuleStyleConfigurator_Show_Labels);
        this.showLabels = new Button(this.container, 32);
        this.showLabels.setData((Object)true);
        this.messageLabel = new Label(this.container, 64);
        return this.container;
    }

    protected void refresh() {
        this.getApplyAction().setEnabled(false);
        this.removeListeners();
        try {
            GraticuleStyle oldStyle = (GraticuleStyle)this.getStyleBlackboard().get("net.refractions.udig.tool.edit.mapgraphic.graticule.style");
            if (oldStyle == null) {
                oldStyle = GraticuleStyle.DEFAULT;
            }
            this.style = new GraticuleStyle(oldStyle);
            this.messageLabel.setText("");
            this.lineWidth.setSelection(this.style.getLineWidth());
            this.setLineStyle(this.style);
            Color color = this.style.getFontColor();
            this.fontColor.setColorValue(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
            color = this.style.getLineColor();
            this.lineColor.setColorValue(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
            this.showLabels.setSelection(this.style.isShowLabels());
            this.opacity.setSelection(this.style.getOpacity());
        }
        finally {
            this.addListeners();
        }
    }

    private void setLineStyle(GraticuleStyle style2) {
        switch (this.style.getLineStyle()) {
            case 2: {
                this.lineStyle.select(this.lineStyle.indexOf(LINE_DASH));
                break;
            }
            case 4: {
                this.lineStyle.select(this.lineStyle.indexOf(LINE_DASHDOT));
                break;
            }
            case 5: {
                this.lineStyle.select(this.lineStyle.indexOf(LINE_DASHDOTDOT));
                break;
            }
            case 3: {
                this.lineStyle.select(this.lineStyle.indexOf(LINE_DOT));
                break;
            }
            case 1: {
                this.lineStyle.select(this.lineStyle.indexOf(LINE_SOLID));
                break;
            }
            default: {
                throw new RuntimeException(NLS.bind((String)Messages.GridStyleConfigurator_1, (Object)this.style.getLineStyle()));
            }
        }
    }

    public void preApply() {
        if (this.lineWidth.isFocusControl()) {
            this.kickWidget((Control)this.lineWidth);
        } else if (this.lineStyle.isFocusControl()) {
            this.kickWidget((Control)this.lineStyle);
        }
    }

    private void kickWidget(Control widget) {
        this.container.setFocus();
        widget.setFocus();
        while (widget.getDisplay().readAndDispatch()) {
        }
    }

    public void handleEvent(Event e) {
        if (e.type == 2 && e.character == '\r') {
            this.makeActionDoStuff();
        } else {
            if (!this.isChanged(e)) {
                return;
            }
            this.getApplyAction().setEnabled(true);
            this.style.setFontColor(GraticuleLinesConfigurator.toColor(this.fontColor.getColorValue()));
            this.style.setLineColor(GraticuleLinesConfigurator.toColor(this.lineColor.getColorValue()));
            this.style.setLineStyle(this.parseLineStyle());
            this.style.setLineWidth(this.lineWidth.getSelection());
            this.style.setShowLabels(this.showLabels.getSelection());
            this.style.setOpacity(this.opacity.getSelection());
            this.getStyleBlackboard().put("net.refractions.udig.tool.edit.mapgraphic.graticule.style", (Object)this.style);
        }
    }

    private boolean isChanged(Event e) {
        if (!this.style.getFontColor().equals(GraticuleLinesConfigurator.toColor(this.fontColor.getColorValue()))) {
            return true;
        }
        if (this.style.getLineStyle() != this.parseLineStyle()) {
            return true;
        }
        if (!this.style.getLineColor().equals(GraticuleLinesConfigurator.toColor(this.lineColor.getColorValue()))) {
            return true;
        }
        if (this.style.getLineWidth() != this.lineWidth.getSelection()) {
            return true;
        }
        if (this.style.isShowLabels() != this.showLabels.getSelection()) {
            return true;
        }
        return this.style.getOpacity() != this.opacity.getSelection();
    }

    private int parseLineStyle() {
        String selectedString = GraticuleLinesConfigurator.selectedString(this.lineStyle);
        if (selectedString.equals(LINE_SOLID)) {
            return 1;
        }
        if (selectedString.equals(LINE_DASH)) {
            return 2;
        }
        if (selectedString.equals(LINE_DOT)) {
            return 3;
        }
        if (selectedString.equals(LINE_DASHDOT)) {
            return 4;
        }
        if (selectedString.equals(LINE_DASHDOTDOT)) {
            return 5;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.GridStyleConfigurator_2, (Object)selectedString));
    }

    static Color toColor(RGB rgb) {
        return new Color(rgb.red, rgb.green, rgb.blue);
    }

    static String selectedString(Combo item) {
        int selectionIndex = item.getSelectionIndex();
        return item.getItem(selectionIndex);
    }
}

